package caslayout.ui;

import java.io.IOException;
import java.util.Properties;

import caslayout.util.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CALMConfig.java,v 1.2 2007/10/08 18:00:40 bozyurt Exp $
 */

public class CALMConfig {
	protected String templateDir;
	protected String dbURL;
	protected String dbSchema;
	protected String user;
	private String pwd;
	private String dbType;
	protected String scaSchemaFile;
	protected String scaGenDir;
	protected transient boolean noPassword;

	public CALMConfig(String propertiesName) throws IOException {
		Properties props = GenUtils.loadProperties(propertiesName);
		templateDir = props.getProperty("template.dir");
		dbURL = props.getProperty("db_url");
		dbSchema = props.getProperty("db_schema");
		user = props.getProperty("user");
		pwd = props.getProperty("pwd");
		dbType = props.getProperty("db_type");
		scaSchemaFile = props.getProperty("sca.schema");
		scaGenDir = props.getProperty("sca.directory");
	}

	public void setDbURL(String newDbURL) {
		this.dbURL = newDbURL;
	}

	public void setDbSchema(String newDbSchema) {
		this.dbSchema = newDbSchema;
	}

	public void setUser(String newUser) {
		this.user = newUser;
	}

	public void setPwd(String newPwd) {
		this.pwd = newPwd;
	}

	public void setDbType(String newDbType) {
		this.dbType = newDbType;
	}

	public void setScaSchemaFile(String scaSchemaFile) {
		this.scaSchemaFile = scaSchemaFile;
	}

	public String getDbURL() {
		return this.dbURL;
	}

	public String getDbSchema() {
		return this.dbSchema;
	}

	public String getTemplateDir() {
		return this.templateDir;
	}

	public String getUser() {
		return this.user;
	}

	public String getPwd() {
		return this.pwd;
	}

	public String getDbType() {
		return this.dbType;
	}

	public String getScaSchemaFile() {
		return scaSchemaFile;
	}

	public boolean isNoPassword() {
		return noPassword;
	}

	public void setNoPassword(boolean noPassword) {
		this.noPassword = noPassword;
	}

	public String getScaGenDir() {
		return scaGenDir;
	}

}