package caslayout.ui;

import guilib.common.GenUtils;

import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import caslayout.codegen.struts.StrutsCodegenConfig;
import caslayout.ui.builder.Assessment;
import caslayout.ui.builder.CALMDocBuilder;
import caslayout.ui.builder.CALMDocReader;


/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CALMHelper.java,v 1.9 2008/10/13 23:58:07 bozyurt Exp $
 */
public class CALMHelper {
	public CALMHelper() {
	}

	public static JFileChooser createFileChooser(boolean forSave, String defaultDir) {
		JFileChooser fileChooser = new JFileChooser( new File( defaultDir) );
		if ( forSave) {
			fileChooser.addChoosableFileFilter(new SuffixFileFilter(".xml",
			"XML Layout Document"));

		} else {
			fileChooser.addChoosableFileFilter(new SuffixFileFilter(".calm",
			"Simple Assessment Layout Document"));
			fileChooser.addChoosableFileFilter(new SuffixFileFilter(".xml",
			"XML Layout Document"));
		}
		fileChooser.setAcceptAllFileFilterUsed(false);
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

		return fileChooser;
	}

	public static Document buildDocument(String calmXMLFile, ScoreLayoutPanel slPanel,
			CALMConfig config) throws Exception
	{
		String schemaFile = config.getScaSchemaFile();
		CALMDocReader reader = new CALMDocReader(calmXMLFile, schemaFile);
		Assessment as = reader.load();

		CALMDocBuilder builder = new CALMDocBuilder(as, config, slPanel);

		Document doc = builder.build();
		return doc;
	}

	public static ImageIcon makeButtonIcon(String imageName)
	{
		String imgLocation = "/images/" + imageName;
		java.net.URL imageURL = ClinicalAssessmentLayoutManager.class
				.getResource(imgLocation);
		if (imageURL == null)
			return null;
		return new ImageIcon(imageURL);
	}

	public static JButton makeToolbarButton(Action action)
	{
		JButton button = new JButton(action);
		if (button.getIcon() != null)
			button.setText("");
		return button;
	}

	public static JButton makeToolbarButton(String imageName, String altText)
	{
		ImageIcon icon = makeButtonIcon(imageName);
		JButton button = new JButton();
		if (icon != null) {
			button.setIcon(icon);
		} else {
			button.setText(altText);
		}
		return button;
	}

	public static Map<String, String> getInformantOptionsMap()
	{
		Map<String,String> labelValueMap = new LinkedHashMap<String, String>(23);

		labelValueMap.put("unknown relationship", "0");
		labelValueMap.put("self", "1");
		labelValueMap.put("husband", "-3000");
		labelValueMap.put("wife", "-3001");
		labelValueMap.put("mother", "11");
		labelValueMap.put("father", "13");
		labelValueMap.put("mother-in-law", "15");
		labelValueMap.put("father-in-law", "17");
		labelValueMap.put("sister", "21");
		labelValueMap.put("brother", "23");
		labelValueMap.put("sister-in-law", "25");
		labelValueMap.put("brother-in-law", "27");
		labelValueMap.put("grandmother", "-2000");
		labelValueMap.put("grandfather", " -2001");
		labelValueMap.put("granddaughter", "-2002");
		labelValueMap.put("grandson", "-2003");
		labelValueMap.put("daughter", "31");
		labelValueMap.put("son", "33");
		labelValueMap.put("daughter-in-law", "35");
		labelValueMap.put("son-in-law", "37");
		labelValueMap.put("aunt", "41");
		labelValueMap.put("uncle", "45");
		labelValueMap.put("niece", "43");
		labelValueMap.put("nephew", "47");
		labelValueMap.put("colleague", "51");
		labelValueMap.put("roommate", "53");
		labelValueMap.put("associate", "-4000");
		labelValueMap.put("cousin", "-4001");
		labelValueMap.put("partner", "-4002");
		labelValueMap.put("guardian", "-4003");
		labelValueMap.put("other relative", "-4004");
		labelValueMap.put("friend", "-1000");
		labelValueMap.put("health professional", "-1001");
		labelValueMap.put("medical record", "-1002");

		// make the key and value same since in the database the uniqueids are
		// different than
		// these codes
		for (String key : labelValueMap.keySet()) {
			labelValueMap.put(key, key);
		}

		return labelValueMap;
	}

	public static String showDropdownTypeSelectionDialog(Component parent)
	{
		String[] types = { "Informant", "Regular", "Dynamic" };
		String selection = (String) JOptionPane.showInputDialog(parent,
				"Please select dropdown type", "Dropdown Types",
				JOptionPane.PLAIN_MESSAGE, null, types, "Informant");
		return selection;
	}

	public static void showError(Component parent, String msg) {
		showError(parent, msg, null);
	}

	public static void showError(Component parent, String msg, String title) {
		if ( title == null){
			title = "Error";
		}
		JOptionPane.showMessageDialog(parent, msg, title,	JOptionPane.ERROR_MESSAGE);
	}

	public static void showWarning(Component parent, String msg, String title) {
		JOptionPane.showMessageDialog(parent, msg, title,	JOptionPane.WARNING_MESSAGE);
	}

	public static void showMessage(Component parent, String msg, String title) {
		JOptionPane.showMessageDialog(parent, msg, title,	JOptionPane.INFORMATION_MESSAGE);
	}


	public static SavedState loadState()
	{
		SavedState ss = new SavedState();
		String stateFile = System.getProperty("user.home") + File.separator
				+ ".calm_state.ser";
		ss.strutsConfig = new StrutsCodegenConfig();
		if (!new File(stateFile).exists()) {
			return ss;
		}

		try {
			Object o = GenUtils.deserialize(stateFile);
			if (o instanceof SavedState) {
				return (SavedState) o;
			} else if (o instanceof StrutsCodegenConfig) {
				ss.strutsConfig = (StrutsCodegenConfig) o;
			}

		} catch (Exception x) {
			ss.strutsConfig = new StrutsCodegenConfig();
		}
		return ss;
	}

	public static void saveState(SavedState ss)
	{
		if (ss != null) {
			String stateFile = System.getProperty("user.home") + File.separator
					+ ".calm_state.ser";
			try {
				guilib.common.GenUtils.serialize(ss, stateFile);
			} catch (Exception x) {
				x.printStackTrace();
			}
		}
	}

	public static class SavedState implements Serializable {
		private static final long serialVersionUID = 1845609588099413353L;
		StrutsCodegenConfig strutsConfig;
		String lastDirectory;

		public SavedState() {
		}

		public StrutsCodegenConfig getStrutsConfig()
		{
			return this.strutsConfig;
		}

		public String getLastDirectory()
		{
			return this.lastDirectory;
		}

		public void setLastDirectory(String lastDir)
		{
			this.lastDirectory = lastDir;
		}
	}

}
