package caslayout.ui;

import java.beans.*;

import java.awt.*;
import java.awt.geom.*;

import org.jdom.*;
import caslayout.util.*;
import java.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CAPanel.java,v 1.19 2008/10/13 23:58:07 bozyurt Exp $
 */

public class CAPanel extends CAContainer {

   public CAPanel() {
      super(new CAGridLayout(false));
   }

   public CAPanel(ILayoutManager layoutMan, int x, int y, int width, int height) {
      this(layoutMan, x, y, width, height, UIDManager.getInstance()
            .getNextUID());
   }

   public CAPanel(ILayoutManager layoutMan, int x, int y, int width,
         int height, String id) {
      super(x, y, layoutMan, id);
      this.width = width;
      this.height = height;

      setBounds(new Rectangle2D.Double(x, y, width, height));
   }

   public CAPanel(CAPanel other) {
      super(other);
   }

   public void setLayoutMan(ILayoutManager layoutMan) {
      this.layoutMan = layoutMan;
   }

   public ILayoutManager getLayoutMan() {
      return layoutMan;
   }

   public void draw(Graphics2D g2) {
      if (layoutMan != null) {
         layoutMan.displayLayoutGrid(this, g2, false);
      }
      super.draw(g2);
   }

   public Object clone() {
      return new CAPanel(this);
   }

   public static void setPersistenceDelegate(Encoder encoder) {
      encoder.setPersistenceDelegate(CAPanel.class,
            new DefaultPersistenceDelegate() {
               protected void initialize(Class<?> type, Object oldInstance,
                     Object newInstance, Encoder out) {
                  super.initialize(type, oldInstance, newInstance, out);
                  CAPanel container = (CAPanel) oldInstance;
                  for (int i = 0; i < container.components.size(); i++) {
                     IDisplayComponent ic = (IDisplayComponent) container.components
                           .get(i);
                     if (ic != null) {
                        // System.out.println("adding component "+ i);
                        out.writeStatement(new Statement(oldInstance, "add",
                              new Object[] { ic, new Integer(i) }));
                     }
                  }

               }
            });
   }

   public static CAPanel initializeFromXML(Element e) {
      int x = 0, y = 0, width = 0, height = 0;
      boolean group = false;
      String id = "", name = "";
      x = XMLUtils.getPropertyValue("x", e, x);
      y = XMLUtils.getPropertyValue("y", e, y);
      width = XMLUtils.getPropertyValue("width", e, width);
      height = XMLUtils.getPropertyValue("height", e, height);
      id = XMLUtils.getStringPropertyValue("id", e, id);
      name = XMLUtils.getStringPropertyValue("name", e, name);

      // log.info(id + " isGroup=" + e.getAttributeValue("isGroup"));
      group = Boolean.valueOf(e.getAttributeValue("isGroup")).booleanValue();

      String refID = XMLUtils.getReferencePropertyValue("parent", e, null);
      IDisplayComponent parent = null;
      if (refID != null) {
         parent = (IDisplayComponent) XMLUtils.getReferencedObject(refID, e);
      }

      ILayoutManager layoutMan = null;

      // Element layoutElem = XMLUtils.getObjectElementByName(e, "layoutMan");
      Element layoutElem = e.getChild("layout-man");
      if (layoutElem != null) {
         layoutMan = (ILayoutManager) XMLUtils.prepareObject(layoutElem);
      }

      refID = e.getAttributeValue("id");
      CAPanel panel = new CAPanel(layoutMan, x, y, width, height, id);
      XMLUtils.registerObject(refID, panel);

      panel.parent = parent;
      panel.setIsGroup(group);
      panel.setName(name);

      Element insetsElem = e.getChild("insets");
      if (insetsElem != null) {
         int left = 0, right = 0, top = 0, bottom = 0;
         left = XMLUtils.getPropertyValue("left", insetsElem, left);
         right = XMLUtils.getPropertyValue("right", insetsElem, right);
         top = XMLUtils.getPropertyValue("top", insetsElem, top);
         bottom = XMLUtils.getPropertyValue("bottom", insetsElem, bottom);
         Insets insets = new Insets(top, left, bottom, right);
         panel.insets = insets;
      }

      XMLUtils.ListInfo listInfo = XMLUtils.prepareList("components", e);
      panel.components = new ArrayList<IDisplayComponent>(listInfo.getList()
            .size());
      for (Object elem : listInfo.getList()) {
         panel.components.add((IDisplayComponent) elem);
      }
      // panel.components = listInfo.getList() ;

      // for each cell constraint find the corresponding display component
      // and bind the cell location with the corresponding display component
      java.util.List<CellConstraint> cellCons = ((CAGridLayout) layoutMan)
            .enumerateCellConstraints();
      int offset = 0;
      for (Iterator<CellConstraint> iter = cellCons.iterator(); iter.hasNext();) {
         CellConstraint cc = iter.next();
         IDisplayComponent ic = null;
         if (offset >= panel.getComponents().size())
            break;

         ic = (IDisplayComponent) panel.getComponents().get(offset);
         ++offset;
         if (ic != null) {
            ((CAGridLayout) layoutMan).putToDispCompMap(cc.getRowIdx(), cc
                  .getColIdx(), ic);
         }
      }
      return panel;
   }

   public Element toXML(Element root) {
      Element e = super.toXML(root);
      e.setAttribute("id", String.valueOf(this.hashCode()));
      e.setAttribute("class", "caslayout.ui.CAPanel");
      return e;
   }

}
