package caslayout.ui;

import org.jdom.Element;


/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CellConstraint.java,v 1.3 2006/03/29 02:25:03 bozyurt Exp $
 */
public abstract class CellConstraint {
  protected int rowIdx;
  protected int colIdx;

  public CellConstraint() {}

  public CellConstraint(int rowIdx, int colIdx) {
     this.rowIdx = rowIdx;
     this.colIdx = colIdx;
  }

  //---------------------- setters --------------
  public void setRowIdx(int newRowIdx) { this.rowIdx = newRowIdx; }
  public void setColIdx(int newColIdx) { this.colIdx = newColIdx; }
  //---------------------- getters --------------
  public int getRowIdx() { return this.rowIdx; }
  public int getColIdx() { return this.colIdx; }

  /**
   * 
   * @return true if the width of the cell is zero
   */
  public abstract boolean hasZeroWidth(); 
  /**
   *
   * @param ch the height of the cell assuming every row is spaced equal.
   * @param vGap vertical gap between cells
   * @param totHeight the available total height of the container
   * @return the height of the cell after application of the constraint
   */
  public abstract double calculateHeight(double ch, double vGap, double totHeight);


  /**
   *
   * @param cw the width of the cell assuming every row is spaced equal.
   * @param hGap horizontal gap between cells
   * @param totWidth the available total width of the container
   * @return the width of the cell after application of the constraint
   */
  public abstract double calculateWidth(double cw, double hGap, double totWidth);


  public abstract Element toXML(Element root);
}