package caslayout.ui;

import java.awt.*;
import java.awt.geom.*;

import org.jdom.*;
import caslayout.util.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CheckBoxDisplayComponent.java,v 1.14 2005/09/09 01:36:07 bozyurt Exp $
 */

public class CheckBoxDisplayComponent extends AbstractDisplayComponent {
	protected MultilineString label;

	protected String value;

	public CheckBoxDisplayComponent() {
		super();
	}

	public CheckBoxDisplayComponent(String id) {
		super(id);
	}

	public CheckBoxDisplayComponent(String labelText, int x, int y,
			Component peer) {
		super(x, y, peer);
		this.label = new MultilineString();
		this.label.setText(labelText);
	}

	public CheckBoxDisplayComponent(MultilineString label, int x, int y,
			Component peer) {
		super(x, y, peer);
		this.label = label;
		getBounds((Graphics2D) peer.getGraphics());
	}

	public CheckBoxDisplayComponent(int x, int y, Component peer) {
		this((MultilineString) null, x, y, peer);
	}

	public CheckBoxDisplayComponent(CheckBoxDisplayComponent other) {
		super(other);
		this.id = UIDManager.getInstance().getNextUID();
		// super( other.x, other.y, other.peer,
		// UIDManager.getInstance().getNextUID(), other.name,
		// Justification.CENTER_JUSTIFICATION);
		this.label = new MultilineString(other.label);
		getBounds((Graphics2D) peer.getGraphics());
	}

	public void draw(Graphics2D g2) {
		Rectangle2D r = getBounds(g2);
		int totGap = 6;
		Color oldColor = g2.getColor();
		if (selected) {
			g2.setColor(Color.blue);
			if (label != null)
				label.setTextColor(Color.blue);
		} else if (groupID != null) {
			g2.setColor(Color.magenta);
			if (label != null)
				label.setTextColor(Color.magenta);
			// show group id
			super.showGroupID(g2, groupID, r, Color.cyan);
		} else {
			if (label != null)
				label.setTextColor(Color.black);
		}

		if (getShowQuestions())
			super.showQuestion(g2, r, Color.ORANGE);

		if (getShowAssociations())
			super.showScoreName(g2, r, Color.cyan);

		if (label != null && label.getText().length() > 0) {
			Rectangle2D labelBounds = label.getBounds(g2);
			double sideLength = Math.min(labelBounds.getHeight() - 2, 8);

			double y2 = r.getY() + r.getHeight() / 2 - sideLength / 2;

			Dimension2D compDim = new Dimension(
					(int) (sideLength + totGap + labelBounds.getWidth()),
					(int) labelBounds.getHeight());
			Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim,
					justification);

			label.draw(g2, new Rectangle2D.Double(point.getX() + sideLength
					+ totGap, point.getY(), labelBounds.getWidth(), labelBounds
					.getHeight()));

			Rectangle2D checkBox = new Rectangle2D.Double(point.getX() + totGap
					/ 2, y2, sideLength, sideLength);
			g2.draw(checkBox);

		} else {
			// just draw the check box
			double sideLength = 8;

			Dimension2D compDim = new Dimension((int) sideLength,
					(int) sideLength);
			Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim,
					justification);

			Rectangle2D checkBox = new Rectangle2D.Double(point.getX(), point
					.getY(), sideLength, sideLength);

			g2.draw(checkBox);
		}
		g2.setColor(oldColor);
	}

	public Rectangle2D getBounds(Graphics2D g2) {
		if (bounds == null) {
			if (label != null && label.getText().length() > 0) {
				bounds = label.getBounds(g2);
				double lh = bounds.getHeight();
				bounds.setFrame(bounds.getX(), bounds.getY(), lh
						+ bounds.getWidth(), bounds.getHeight());
			} else {
				bounds = new Rectangle2D.Double(0, 0, 10, 10);
			}
		}
		return bounds;
	}

	public String getText() {
		return label.getText();
	}

	public void setText(String txt) {
		if (label == null) {
			label = new MultilineString(txt);
		} else {
			label.setText(txt);
		}
	}

	public int getGap() {
		return label.getGap();
	}

	public void setGap(int newGap) {
		label.setGap(newGap);
	}

	public void setValue(String newValue) {
		this.value = newValue;
	}

	public String getValue() {
		return this.value;
	}

	public Object clone() {
		return new CheckBoxDisplayComponent(this);
	}

	public static CheckBoxDisplayComponent initializeFromXML(Element e) {
		String text = XMLUtils.getStringPropertyValue("text", e, null);
		String value = XMLUtils.getStringPropertyValue("value", e, null);
		String id = XMLUtils.getStringPropertyValue("id", e, "");
		String cssClass = XMLUtils.getStringPropertyValue("cssClass", e, null);

		CheckBoxDisplayComponent cdc = new CheckBoxDisplayComponent(id);
		if (text != null) {
			cdc.setText(text);
		}
		String justificationValue = XMLUtils.getStringPropertyValue(
				"justification", e, null);
		if (justificationValue != null) {
			cdc.setJustification(Justification
					.findJustification(justificationValue));
		}

		cdc.x = XMLUtils.getPropertyValue("x", e, 0);
		cdc.y = XMLUtils.getPropertyValue("y", e, 0);
		cdc.width = XMLUtils.getPropertyValue("height", e, 0);
		cdc.height = XMLUtils.getPropertyValue("height", e, 0);
		cdc.cssClass = cssClass;
		cdc.value = value;
		String refID = XMLUtils.getReferencePropertyValue("parent", e, null);
		if (refID != null)
			cdc.parent = (IDisplayComponent) XMLUtils.getReferencedObject(
					refID, e);
		return cdc;
	}

	public Element toXML(Element root) {
		Element e = super.toXML(root);
		e.setAttribute("class", "caslayout.ui.CheckBoxDisplayComponent");
		if (label != null)
			e.addContent(XMLUtils.prepareProperty("text", label.getText()));
		if (value != null)
			e.addContent(XMLUtils.prepareProperty("value", value));
		e.addContent(XMLUtils.prepareProperty("justification", justification
				.getValue()));
		return e;
	}

}
