package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import caslayout.util.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ColumnsPercentSelectionDialog.java,v 1.4 2007/10/08 18:00:40 bozyurt Exp $
 */
public class ColumnsPercentSelectionDialog extends BaseDialog {
	private static final long serialVersionUID = 8384910065659129975L;
	protected double[] colPercents;
	protected JTextField[] colPercentFields;
	protected JLabel totPercentLabel;

	public ColumnsPercentSelectionDialog(Frame owner, String title,
			double[] colPercents) {
		super(owner, title, new String[] {"Cancel", "OK"});
		setDefaultButton("Cancel");
		this.colPercents = colPercents;
		init();
		pack();
	}

	public void init()
	{
		this.colPercentFields = new JTextField[colPercents.length];
		JPanel panel = new JPanel(new GridLayout(2, colPercents.length + 1, 3,
				3));
		panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		for (int i = 1; i <= colPercents.length; i++) {
			JLabel label = new JLabel("Col " + i, JLabel.CENTER);
			label.setMinimumSize(new Dimension(40, 0));
			label.setPreferredSize(new Dimension(40, 0));

			panel.add(label);
		}

		panel.add(new JLabel("Total"));

		for (int i = 0; i < colPercents.length; i++) {
			colPercentFields[i] = new JTextField(2);
			PercentFieldDocListener listener = new PercentFieldDocListener(
					this, colPercentFields[i]);
			colPercentFields[i].getDocument().addDocumentListener(listener);
			colPercentFields[i].setText(String.valueOf(colPercents[i]));
			panel.add(colPercentFields[i]);
		}

		totPercentLabel = new JLabel(GenUtils.formatDouble(getTotal()));
		panel.add(totPercentLabel);

		panel
				.setBorder(BorderFactory
						.createTitledBorder("Set column percents"));

		getContentPane().add(panel);
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				double total = getTotal();
				if (total != 100.0) {
					CALMHelper.showError(this, "Total percentage must be 100%",
							"Validation Error");
					return;
				}
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

	protected double getTotal()
	{
		double sum = 0;
		for (int i = 0; i < colPercents.length; i++) {
			sum += colPercents[i];
		}
		return sum;
	}

	protected void updatePercents(JTextField field)
	{
		for (int i = 0; i < colPercentFields.length; i++) {
			if (colPercentFields[i] == field) {
				double num;
				try {
					num = Double.parseDouble(field.getText().trim());
					colPercents[i] = num;
					double total = getTotal();
					if (totPercentLabel != null)
						totPercentLabel.setText(GenUtils.formatDouble(total));

				} catch (NumberFormatException nfe) {
					// field.setText( GenUtils.formatDouble( colPercents[i]) );
				}
			}
		}
	}

	public double[] getColPercents()
	{
		return colPercents;
	}

	class PercentFieldDocListener implements DocumentListener {
		ColumnsPercentSelectionDialog cpsDlg;
		JTextField field;

		public PercentFieldDocListener(ColumnsPercentSelectionDialog cpsDlg,
				JTextField field) {
			this.cpsDlg = cpsDlg;
			this.field = field;
		}

		public void changedUpdate(DocumentEvent e)
		{
			cpsDlg.updatePercents(field);
		}

		public void insertUpdate(DocumentEvent e)
		{
			cpsDlg.updatePercents(field);
		}

		public void removeUpdate(DocumentEvent e)
		{
			cpsDlg.updatePercents(field);
		}
	}
}