package caslayout.ui;

import java.util.List;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import guilib.common.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ContainerSelectionDialog.java,v 1.3 2006/03/29 02:25:03 bozyurt
 *          Exp $
 */
public class ContainerSelectionDialog extends BaseDialog {
   private static final long serialVersionUID = -357978599581489388L;
   protected List<CAContainer> containerHierarchy;
   protected ContainerListModel listModel;
   protected JList list;
   protected CAContainer selectedCon;

   public ContainerSelectionDialog(Frame owner, String title,
         List<CAContainer> containerHierarchy) {
      super(owner, title, new String[] { "OK", "Cancel" });
      this.containerHierarchy = containerHierarchy;
      init();
      pack();

   }

   protected void init() {
      JPanel panel = new JPanel(new BorderLayout(5, 5));

      panel.setBorder(BorderFactory
            .createTitledBorder("Select the Container to edit"));
      panel.add(new JLabel("Ordered from Innermost to the outermost"),
            BorderLayout.NORTH);

      listModel = new ContainerListModel(containerHierarchy);
      list = new JList(listModel);
      if (containerHierarchy.size() >= 1)
         list.setSelectedIndex(0);
      panel.add(list);
      getContentPane().add(panel);
   }

   public CAContainer getSelectedContainer() {
      return selectedCon;
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            this.returnCode = OK_PRESSED;

            int idx = list.getSelectedIndex();
            if (idx != -1) {
               selectedCon = (CAContainer) containerHierarchy.get(idx);
            }
         }
      }
      setVisible(false);
   }

   class ContainerListModel extends AbstractListModel {
      private static final long serialVersionUID = 4795188722954575058L;
      List<CAContainer> conList;

      public ContainerListModel(List<CAContainer> conList) {
         this.conList = conList;
      }

      public int getSize() {
         return conList.size();
      }

      public Object getElementAt(int index) {
         CAContainer con = (CAContainer) conList.get(index);
         return "Container " + con.getId();
      }
   }
}