package caslayout.ui;

import java.awt.Color;
import java.awt.Point;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CurrentState.java,v 1.1 2006/03/29 02:25:03 bozyurt Exp $
 */
public class CurrentState {
	public final static int NONE = 0;
	public final static int SELECTION = 1;
	public final static int INSERT = 2;
	public final static int ASSOCIATE = 3;
	/** to associate selected label(s) with score codes or an AssessmentItem */
	public final static int ASSOCIATE_LABELS = 4;

	protected IDisplayComponent selectedComponent;
	protected boolean multiplePaste = false;
	protected boolean objectUsed = false;
	protected int state = NONE;
	protected Point startPos;
	protected Point endPos;
	protected Color origColor;
	protected ICommand command;
	protected GridSelectState gridSelState;

    public CurrentState() {}
	
	public void setCommand(ICommand cmd)
	{
		this.command = cmd;
	}

	public void setSelectedComponent(IDisplayComponent newSelectedComponent)
	{
		this.selectedComponent = newSelectedComponent;
		objectUsed = false;
		multiplePaste = false;
		state = INSERT;
	}

	public void setMultiplePaste(boolean newMultiplePaste)
	{
		this.multiplePaste = newMultiplePaste;
	}

	public void setObjectUsed(boolean newObjectUsed)
	{
		this.objectUsed = newObjectUsed;
	}

	public void setState(int newState)
	{
		this.state = newState;
	}

	/**
	 * removes the selection appearence from the selected components and
	 * sets the command to null
	 */
	public void clearSelection()
	{
		if (command == null || !(command instanceof SelectionCommand)) {
			return;
		}
		SelectionCommand sc = (SelectionCommand) command;
		if (sc.getSelectedObjects() != null
				&& !sc.getSelectedObjects().isEmpty()) {
			try {
				sc.undo();
			} catch (CommandException cx) {
				ScoreLayoutPanel.log.error("", cx);
			}
		}
		command = null;

	}

	public IDisplayComponent getSelectedComponent()
	{
		if (selectedComponent == null)
			return null;
		if (!objectUsed && !multiplePaste) {
			return this.selectedComponent;
		} else if (multiplePaste) {
			// return a deep copy
			// log.info(">> returning a deep copy of the selected
			// component");
			return (IDisplayComponent) selectedComponent.clone();
		}
		return null;
	}

	public boolean getMultiplePaste()
	{
		return this.multiplePaste;
	}

	public boolean getObjectUsed()
	{
		return this.objectUsed;
	}

	public int getState()
	{
		return state;
	}

	public Point getEndPos()
	{
		return endPos;
	}

	public void setEndPos(Point endPos)
	{
		this.endPos = endPos;
	}

	public Color getOrigColor()
	{
		return origColor;
	}

	public void setOrigColor(Color origColor)
	{
		this.origColor = origColor;
	}

	public Point getStartPos()
	{
		return startPos;
	}

	public void setStartPos(Point startPos)
	{
		this.startPos = startPos;
	}

	public ICommand getCommand()
	{
		return command;
	}
	
	public GridSelectState getGridSelState()
	{
		return gridSelState;
	}

	public void setGridSelState(GridSelectState gridSelState)
	{
		this.gridSelState = gridSelState;
	}

	
	public static class GridSelectState {
		int startX;
		int startY;
		GridLocation gridLoc;
		CAContainer selected;
		
		
		public GridSelectState(int startx, int starty, GridLocation loc, CAContainer selCon) {
			gridLoc = loc;
			startX = startx;
			startY = starty;
			selected = selCon;
		}
		
		public GridLocation getGridLoc()
		{
			return gridLoc;
		}
		
		public int getStartY()
		{
			return startY;
		}
				
		
		public int getStartX()
		{
			return startX;
		}
		
		public void setStartY(int startY)
		{
			this.startY = startY;
		}

		public void setStartX(int startX)
		{
			this.startX = startX;
		}

		public CAContainer getSelected()
		{
			return selected;
		}
		
	}


	}