package caslayout.ui;

import java.util.*;
import java.util.List;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import org.apache.log4j.*;
import caslayout.exception.*;
import caslayout.propedit.*;
import guilib.common.*;

public class DropdownEditDialog extends BaseDialog {
   private static final long serialVersionUID = -5439620168541075225L;
   protected DropdownDisplayComponent ddc;
   protected DDTableModel tableModel;
   protected JTable lvTable;
   protected JButton addOptionButton, removeOptionButton;
   protected static Logger log = Logger.getLogger(DropdownEditDialog.class);

   public DropdownEditDialog(Frame owner, String title,
         DropdownDisplayComponent ddc) {
      super(owner, title, new String[] { "OK" });
      this.ddc = ddc;
      init();
      pack();
   }

   protected void init() {
      PropertyEditorPanel aPEPanel = null;
      try {
         aPEPanel = new PropertyEditorPanel(ddc);
      } catch (Exception x) {
         log.error("", x);
         aPEPanel = null;
      }
      JPanel tablePanel = new JPanel(new BorderLayout(3, 3));
      tablePanel
            .setBorder(BorderFactory.createTitledBorder("Edit Option List"));
      tableModel = new DDTableModel();
      lvTable = new JTable(tableModel);
      lvTable.setPreferredScrollableViewportSize(new Dimension(220, 80));
      tablePanel.add(new JScrollPane(lvTable));
      addOptionButton = new JButton("Add Option");
      addOptionButton.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
            handleOptionAddition();
         }
      });
      removeOptionButton = new JButton("Remove Option");
      removeOptionButton.addActionListener(new ActionListener() {
         public void actionPerformed(ActionEvent e) {
            handleOptionDeletion();
         }
      });

      // populate the table
      for (Map.Entry<String, String> entry : ddc.getLabelValueMap().entrySet()) {
         String label = entry.getKey();
         String value = entry.getValue();
         tableModel.addRow(label, value);
      }

      JPanel buttonPanel = new JPanel();
      BoxLayout bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS);
      buttonPanel.setLayout(bl);
      buttonPanel.add(addOptionButton);
      buttonPanel.add(Box.createHorizontalGlue());
      buttonPanel.add(removeOptionButton);

      tablePanel.add(buttonPanel, BorderLayout.NORTH);

      JPanel mainPanel = new JPanel(new BorderLayout(3, 3));

      if (aPEPanel != null) {
         aPEPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
         mainPanel.add(aPEPanel, BorderLayout.NORTH);
      }
      mainPanel.add(tablePanel);
      this.getContentPane().add(mainPanel);
   }

   protected void handleOptionAddition() {
      tableModel.addRow("", "");
   }

   protected void handleOptionDeletion() {
      int selRow = lvTable.getSelectedRow();
      if (selRow == -1)
         return;
      tableModel.removeRow(selRow);
   }

   protected void applyChanges() throws ValidationException {
      for (Iterator<String[]> iter = tableModel.data.iterator(); iter.hasNext();) {
         String[] tableRow = (String[]) iter.next();
         if (tableRow[0].trim().length() == 0)
            throw new ValidationException(
                  "You cannot have blank label in an option");
         if (tableRow[1].trim().length() == 0)
            throw new ValidationException(
                  "You cannot have blank value in an option");
      }
      ddc.getLabelValueMap().clear();
      for (Iterator<String[]> iter = tableModel.data.iterator(); iter.hasNext();) {
         String[] tableRow = iter.next();
         ddc.addLabelValue(tableRow[0], tableRow[1]);
      }
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            try {
               applyChanges();
            } catch (ValidationException ve) {
               CALMHelper.showError(this, ve.getMessage(), "Validation Error");
               return;
            }
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

   class DDTableModel extends AbstractTableModel {
      private static final long serialVersionUID = 4128821432140804857L;
      private String[] columnNames;
      private List<String[]> data = new ArrayList<String[]>();

      public DDTableModel() {
         this.columnNames = new String[] { "Label", "Value" };
      }

      public int getRowCount() {
         return data.size();
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         String[] tableRow = (String[]) data.get(row);
         return tableRow[col];
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public Class<?> getColumnClass(int col) {
         return getValueAt(0, col).getClass();
      }

      public boolean isCellEditable(int row, int col) {
         return true;
      }

      public void setValueAt(Object value, int row, int col) {
         String[] tableRow = (String[]) data.get(row);
         tableRow[col] = value.toString();
         fireTableCellUpdated(row, col);
      }

      public void addRow(String label, String value) {
         String[] newRow = new String[2];
         newRow[0] = label;
         newRow[1] = value;
         data.add(newRow);
         fireTableDataChanged();
      }

      public String[] removeRow(int rowIdx) {
         String[] rowData = (String[]) data.remove(rowIdx);
         fireTableDataChanged();
         return rowData;
      }
   }
}// ;
