package caslayout.ui;

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.apache.log4j.*;
import caslayout.exception.*;
import caslayout.propedit.*;
import guilib.common.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DynamicDropdownEditDialog.java,v 1.6 2005/10/07 00:34:44
 *          bozyurt Exp $
 */
public class DynamicDropdownEditDialog extends DropdownEditDialog {
	private static final long serialVersionUID = -7652688369005654038L;
	protected JTextArea queryField;
	protected static Logger log = Logger
			.getLogger(DynamicDropdownEditDialog.class);
	public final static String DEFAULT_QUERY = "select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'";

	public DynamicDropdownEditDialog(Frame owner, String title,
			DropdownDisplayComponent ddc) {
		super(owner, title, ddc);
	}

	protected void init()
	{
		PropertyEditorPanel aPEPanel = null;
		try {
			aPEPanel = new PropertyEditorPanel(ddc);
		} catch (Exception x) {
			log.error("", x);
			aPEPanel = null;
		}
		queryField = new JTextArea(4, 50);
		if (ddc.getSqlQuery() == null || ddc.getSqlQuery().length() == 0) {
			queryField.setText(DEFAULT_QUERY);
		} else {
			queryField.setText(ddc.getSqlQuery());
		}
		JPanel queryPanel = new JPanel(new GridLayout(1, 1));
		queryPanel.setBorder(BorderFactory
				.createTitledBorder("SQL query to populate the dropdown"));
		queryPanel.add(new JScrollPane(queryField));

		JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
		mainPanel.add(aPEPanel, BorderLayout.NORTH);
		mainPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		mainPanel.add(queryPanel);
		this.getContentPane().add(mainPanel);
	}

	protected void applyChanges() throws ValidationException
	{
		String query = queryField.getText().trim();
		if (query.length() == 0)
			throw new ValidationException(
					"A valid SQL query for BIRN database needs to be provided!");
		StringTokenizer stok = new StringTokenizer(query);
		String selectTok = stok.nextToken();
		if (!selectTok.equalsIgnoreCase("select"))
			throw new ValidationException(
					"The Query must start with keyword 'select'!");
		if (!stok.hasMoreTokens()) {
			throw new ValidationException(
					"A single column required after 'select'!");
		}
		String colStr = stok.nextToken();
		if (colStr.indexOf(',') != -1 || colStr.equalsIgnoreCase("from")) {
			throw new ValidationException(
					"A single column required after 'select'!");
		}
		if (!stok.hasMoreTokens()) {
			throw new ValidationException("Keyword 'from' is expected after '"
					+ colStr + "'!");
		}
		ddc.setPopulatedFromDatabase(true);
		ddc.setSqlQuery(query);
	}

	public String getSQLQuery()
	{
		return queryField.getText().trim();
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				try {
					applyChanges();
				} catch (ValidationException ve) {
					CALMHelper.showError(this, ve.getMessage(),
							"Validation Error");
					return;
				}
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}
}
