package caslayout.ui;

import java.awt.*;
import java.awt.geom.*;

public class Grid {
  protected int width;
  protected int height;
  public final static Color PALE_BLUE = new Color(0.9f, 0.8f, 0.9f);

  public Grid(int width, int height) {
    this.width = width;
    this.height = height;
  }

  public void draw(Graphics2D g2, Rectangle2D boundRect) {
    Color oldColor = g2.getColor();
    g2.setColor(PALE_BLUE);
    for (double x = boundRect.getX(); x < boundRect.getMaxX(); x += width ) {
      g2.draw( new Line2D.Double(x, boundRect.getY(), x, boundRect.getMaxY()) );
    }
    for (double y = boundRect.getY(); y < boundRect.getMaxY(); y += height ) {
      g2.draw( new Line2D.Double(boundRect.getX(), y, boundRect.getMaxX(), y) );
    }

    g2.setColor(oldColor);
  }

  /**
   * snaps the rectangle to the nearest grid points
   * @param aRect
   */
  public void snap(Rectangle2D aRect) {

    double sx = Math.round (aRect.getX() / width) * width;
    double sy = Math.round( aRect.getY() / height) * height;

    double swidth = Math.ceil( aRect.getWidth() / (2 * width) ) * (2 *width)  ;
    double sheight = Math.ceil( aRect.getHeight() / (2 * height))  * (2 * height)  ;

    aRect.setFrame(sx, sy, swidth, sheight);

  }

}