package caslayout.ui;

import java.awt.geom.Rectangle2D;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: GridLocation.java,v 1.2 2006/03/29 02:25:03 bozyurt Exp $
 */

public class GridLocation {
	protected int row;
	protected int column;
	protected int idx;
	protected Rectangle2D bounds;
	protected int selGridSide = -1;

	public final static int LEFT = 1;
	public final static int RIGHT = 2;
	public final static int TOP = 3;
	public final static int BOTTOM = 4;

	public GridLocation(int row, int column, Rectangle2D bounds) {
		this.row = row;
		this.column = column;
		this.bounds = bounds;
	}

	// ---------------------- setters --------------
	public void setRow(int newRow)
	{
		this.row = newRow;
	}

	public void setColumn(int newColumn)
	{
		this.column = newColumn;
	}

	public void setBounds(Rectangle2D newBounds)
	{
		this.bounds = newBounds;
	}

	public void setIdx(int newIdx)
	{
		this.idx = newIdx;
	}

	// ---------------------- getters --------------
	public int getRow()
	{
		return this.row;
	}

	public int getColumn()
	{
		return this.column;
	}

	public Rectangle2D getBounds()
	{
		return this.bounds;
	}

	public int getIdx()
	{
		return this.idx;
	}

	public int getSelGridSide()
	{
		return selGridSide;
	}

	public void setSelGridSide(int selGridSide)
	{
		this.selGridSide = selGridSide;
	}

	public String toString()
	{
		StringBuffer buf = new StringBuffer(128);
		buf.append("GridLocation ::[");
		buf.append("row=").append(row).append(",column=").append(column)
				.append(",idx=").append(idx);
		buf.append(']');
		return buf.toString();
	}

	}