package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HelpDialog.java,v 1.5 2006/03/29 02:25:03 bozyurt Exp $
 */
public class HelpDialog extends BaseDialog implements HyperlinkListener {
	private static final long serialVersionUID = -5499067130129038746L;
	JEditorPane htmlPane;
	java.net.URL helpURL;

	public HelpDialog(Frame owner, String title) {
		super(owner, title, new String[] { "OK" });

		htmlPane = new JEditorPane();
		htmlPane.setEditable(false);
		JScrollPane htmlView = new JScrollPane(htmlPane);
		htmlView.setPreferredSize(new Dimension(750, 550));
		helpURL = HelpDialog.class.getResource("/index.html");
		getContentPane().add(htmlView);
		htmlPane.addHyperlinkListener(this);
		pack();

	}

	public int showDialog()
	{
		try {
			htmlPane.setPage(helpURL);
		} catch (Exception x) {
			x.printStackTrace();
		}
		setVisible(true);

		return returnCode;
	}

	public void actionPerformed(ActionEvent e)
	{
		setVisible(false);
	}

	public void hyperlinkUpdate(HyperlinkEvent e)
	{
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			JEditorPane pane = (JEditorPane) e.getSource();
			if (e instanceof HTMLFrameHyperlinkEvent) {
				HTMLFrameHyperlinkEvent he = (HTMLFrameHyperlinkEvent) e;
				HTMLDocument doc = (HTMLDocument) pane.getDocument();
				doc.processHTMLFrameHyperlinkEvent(he);
			} else {
				try {
					pane.setPage(e.getURL());
				} catch (Throwable t) {
					t.printStackTrace();
				}
			}
		}
	}
}