package caslayout.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: IDisplayComponent.java,v 1.14 2008/10/13 23:58:07 bozyurt Exp $
 */
public interface IDisplayComponent extends Cloneable {

   public Rectangle2D getBounds(Graphics2D g2);

   public void setBounds(Rectangle2D r);

   public void draw(Graphics2D g2);

   public void translate(double deltaX, double deltaY);

   public Object clone();

   public void setParent(IDisplayComponent parent);

   public IDisplayComponent getParent();

   public Dimension getPreferredSize();

   public void invalidate();

   public void setX(int newX);

   public void setY(int newY);

   /** returns the ID of the component */
   public String getId();

   public Element toXML(Element root);

   public void setSelected(boolean value);

   public boolean getSelected();

   /**
    * returns true if the display component is contained within the provided
    * rectangle.
    *
    * @param rect
    *           Rectangle2D
    * @param g2
    *           Graphics2D
    * @return boolean returns true if the display component is contained within
    *         the provided rectangle
    */
   public boolean isContained(Rectangle2D rect, Graphics2D g2);

   /**
    * Checks if the provided rectangle <code>rect</code> falls inside this
    * component.
    *
    * @param rect
    *           Rectangle2D
    * @param g2
    *           Graphics2D
    * @return boolean
    */
   public boolean contains(Rectangle2D rect, Graphics2D g2);

   /**
    * recursively checks if the provided component is a member of this display
    * element (only valid for containers)
    *
    * @param ic
    * @return
    */
   public boolean contains(IDisplayComponent ic);

   /** gets the logical group id */
   public String getGroupID();

   /**
    * sets the logical group id
    */
   public void setGroupID(String newGroupID);

   // for question grouping
   public String getQuestionID();

   public void setQuestionID(String newID);

   /**
    * returns the Cascade Style sheet class value
    */
   public String getCSSClass();

   public void setCSSClass(String className);

   public Justification getJustification();

   public void setJustification(Justification newJustification);

   /** if true diplays hints for the associated score */
   public void setShowAssociations(boolean value);

   public boolean getShowAssociations();

   /** if true diplays hints for the question group */
   public void setShowQuestions(boolean value);

   public boolean getShowQuestions();

}
