package caslayout.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ILayoutManager.java,v 1.7 2006/03/29 02:25:03 bozyurt Exp $
 */
public interface ILayoutManager {

	/**
	 * Adds the specified display component to the layout, using the specified
	 * constraint object.
	 * 
	 * @param ic
	 *            the display component to be added
	 * @param constraints
	 */
	void addLayoutComponent(IDisplayComponent ic, Object constraints);

	/**
	 * Removes the specified display component from the layout
	 * 
	 * @param ic
	 *            the display component to be removed
	 */
	void removeLayoutComponent(IDisplayComponent ic);

	/**
	 * Given a container containing display components, it calculates the
	 * preferred size dimensions
	 * 
	 * @param parent
	 * @return
	 */
	Dimension preferredLayoutSize(CAContainer parent);

	void layoutContainer(CAContainer parent);

	void invalidateLayout(CAContainer parent);

	void displayLayoutGrid(CAContainer parent, Graphics2D g2,
			boolean debugEnabled);

	Object hitTest(int mX, int mY, CAContainer parent, Graphics2D g2);

	Object clone();

	/**
	 * persists the state of the layout manager as XML.
	 * 
	 * @param root
	 * @return
	 */
	Element toXML(Element root);

	public void setSelected(boolean value);

	public boolean getSelected();

	public void setGridColor(Color color);

	public Color getGridColor();

}
