package caslayout.ui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: LogicalGroup.java,v 1.9 2008/10/13 23:58:07 bozyurt Exp $
 */
public class LogicalGroup {
  protected String id;
  protected LinkedList<IDisplayComponent> elements;

  public LogicalGroup(String id) {
    this.id = id;
    elements = new LinkedList<IDisplayComponent>();
  }

  public void addElement(IDisplayComponent idc) {
    // container's cannot be grouped
     if ( idc instanceof CAContainer)
       return;
     // a display component needs to be free to be grouped
     if ( idc.getGroupID() != null)
       return;
     // only display components of the same type can be grouped
     if ( !elements.isEmpty() ) {
       IDisplayComponent lastElement = elements.getLast();
       if ( lastElement.getClass() != idc.getClass() )
         return;
     }

     idc.setGroupID(id);
     elements.add( idc );
  }

  public String getId() { return this.id; }

  public int getSize() { return elements.size(); }

  public List<IDisplayComponent> getElements() { return elements; }

  public void ungroup() {
     for (Iterator<IDisplayComponent> iter = elements.iterator(); iter.hasNext(); ) {
       IDisplayComponent idc = iter.next();
       idc.setGroupID(null);
     }
     elements.clear();
  }

  public IDisplayComponent findComponent(String componentID) {
    for (Iterator<IDisplayComponent> iter = elements.iterator(); iter.hasNext(); ) {
      IDisplayComponent adc = iter.next();
      if ( adc.getId().equals(componentID) )
        return adc;
    }
    return null;
  }

  public IDisplayComponent findLeftMostComponent() {
	  class IDCInfo {
		  IDisplayComponent leftMost;
		  int idx; // idx within the container the smaller the more left component is
		  public IDCInfo(IDisplayComponent idc) {
			  leftMost = idc;
		  }
	  }
	  IDCInfo idcInfo = null;
	  Map<CAContainer, IDCInfo> conMap = new LinkedHashMap<CAContainer, IDCInfo>(7);

	  for (Iterator<IDisplayComponent> iter = elements.iterator(); iter.hasNext(); ) {
	      IDisplayComponent adc = iter.next();
	      CAContainer con =  (CAContainer) adc.getParent();
	      idcInfo = conMap.get(con);
	      if ( idcInfo == null) {
	    	  idcInfo = new IDCInfo(adc);
	    	  idcInfo.idx = con.findComponentIndex(adc);
	    	  conMap.put(con, idcInfo);
	      } else {
	    	  int idx = con.findComponentIndex(adc);
	    	  if ( idcInfo.idx > idx) {
	    		  idcInfo.idx = idx;
	    		  idcInfo.leftMost = adc;
	    	  }
	      }
	  }
	  // TODO determine the outermost container and use its leftmost component
	  idcInfo = conMap.values().iterator().next();

	  return idcInfo.leftMost;
  }

 public static List<IDisplayComponent> getGroupableComponents(IDisplayComponent parent) {
   List<IDisplayComponent> groupableList = new LinkedList<IDisplayComponent>();
   getGroupableComponents(parent, groupableList);
   return groupableList;
 }

  protected static void getGroupableComponents(IDisplayComponent parent, List<IDisplayComponent> groupableList) {
    if ( parent instanceof CAContainer) {
      CAContainer con = (CAContainer) parent;
      for (Iterator<IDisplayComponent> iter = con.getComponents().iterator(); iter.hasNext(); ) {
        IDisplayComponent child = iter.next();
        if ( child instanceof RadioButtonDisplayComponent ||
             child instanceof CheckBoxDisplayComponent)
        {
           groupableList.add(child);
        } else if ( child instanceof CAContainer) {
           getGroupableComponents(child, groupableList);
        }
      }
    } else if ( parent instanceof RadioButtonDisplayComponent ||
             parent instanceof CheckBoxDisplayComponent)
    {
         groupableList.add(parent);
    }
  }

  public Element toXML(Element root) {
    Element e = new Element("group");
    e.setAttribute("id", id);

    for (Iterator<IDisplayComponent> iter = elements.iterator(); iter.hasNext(); ) {
      IDisplayComponent ic = iter.next();
      Element ce = new Element("display-comp");
      ce.setAttribute("id", ic.getId());
      e.addContent(ce);
    }
    return e;
  }


  public static LogicalGroup initializeFromXML(Element e, Document document) {
    String id = e.getAttributeValue("id");
    LogicalGroup lg = new LogicalGroup(id);
    List<?> children = e.getChildren("display-comp");
    for (Iterator<?> iter = children.iterator(); iter.hasNext(); ) {
      Element child = (Element)iter.next();
      String refID = child.getAttributeValue("id");
      IDisplayComponent idc = document.findDisplayComponent(refID);
     if ( idc != null) {
        lg.addElement(idc);
        idc.setGroupID(id);
     } else {
       document.handleMissingCompInLogicalGroup(refID);
     }
    }
    if ( lg.elements.size() == 0)
      return null;
    return lg;
  }

  public String toString() {
    StringBuffer sb = new StringBuffer(128);
    sb.append("LogicalGroup::[");
    sb.append("id=").append(id);
    sb.append(']');
    return sb.toString();
  }

}