package caslayout.ui;

import java.util.*;
import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: LogicalGroupRepository.java,v 1.4 2007/10/08 18:00:41 bozyurt
 *          Exp $
 */
public class LogicalGroupRepository {
   protected Map<String, LogicalGroup> repositoryMap = null;
   protected int idCount = 0;
   protected static LogicalGroupRepository instance;

   protected LogicalGroupRepository() {
      repositoryMap = Collections
            .synchronizedMap(new HashMap<String, LogicalGroup>());
   }

   public synchronized static LogicalGroupRepository getInstance() {
      if (instance == null) {
         instance = new LogicalGroupRepository();
      }
      return instance;
   }

   public synchronized void clear() {
      repositoryMap.clear();
   }

   public synchronized void populateFromXML(Element e, Document document) {
      List<?> children = e.getChildren("group");
      int maxID = 0;
      clear();
      for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
         Element ce = (Element) iter.next();
         LogicalGroup lg = LogicalGroup.initializeFromXML(ce, document);
         if (lg != null) {
            int id = Integer.parseInt(lg.getId());
            if (id > maxID)
               maxID = id;
            repositoryMap.put(lg.getId(), lg);
         }
      }
      idCount = maxID;
   }

   public synchronized LogicalGroup createLogicalGroup() {
      ++idCount;
      return new LogicalGroup(String.valueOf(idCount));
   }

   public void add(LogicalGroup lg) {
      repositoryMap.put(lg.getId(), lg);
   }

   public void removeGroup(String groupID) {
      repositoryMap.remove(groupID);
   }

   public LogicalGroup get(String groupID) {
      return repositoryMap.get(groupID);
   }

   public Set<String> getGroupIDs() {
      return repositoryMap.keySet();
   }

   public synchronized LogicalGroup findMatching(IDisplayComponent idc) {
      if (idc.getGroupID() == null)
         return null;
      for (Iterator<LogicalGroup> iter = repositoryMap.values().iterator(); iter
            .hasNext();) {
         LogicalGroup lg = iter.next();
         if (idc.getGroupID() == lg.getId()) {
            return lg;
         }
      }
      return null;
   }

}