package caslayout.ui;

import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import caslayout.codegen.struts.StrutsCodegenConfig;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssociationHelper;
import caslayout.util.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MinimumCodeGenInfoDlg.java,v 1.5 2005/09/09 01:36:07 bozyurt
 *          Exp $
 */

public class MinimumCodeGenInfoDlg extends BaseDialog {
	private static final long serialVersionUID = 2224726904523207527L;
	protected StrutsCodegenConfig config;
	protected Document doc;
	protected JPanel labelPanel;
	protected JPanel fieldPanel;
	protected FileNameValueField clinicalHomeDirField;

	public MinimumCodeGenInfoDlg(Frame owner, String title,
			StrutsCodegenConfig config, Document doc) {
		super(owner, title, new String[] { "Cancel", "OK" });
		setDefaultButton("Cancel");
		this.config = config;
		this.doc = doc;
		init();
		pack();
	}

	protected void init()
	{
		labelPanel = new JPanel(new GridLayout(1, 1, 5, 5));
		labelPanel.add(new JLabel("Clinical web app Home directory:",
				JLabel.RIGHT));

		fieldPanel = new JPanel(new GridLayout(1, 1, 5, 5));
		clinicalHomeDirField = new FileNameValueField(null, 25, FileNameValueField.DIR_ONLY); 
		initializeFields();

		fieldPanel.add(clinicalHomeDirField);

		JPanel fieldGroupPanel = new JPanel(new BorderLayout(3, 3));
		fieldGroupPanel.add(labelPanel, BorderLayout.WEST);
		fieldGroupPanel.add(fieldPanel);

		JPanel mainPanel = new JPanel(new BorderLayout(3, 3));
		mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		mainPanel.add(fieldGroupPanel);

		getContentPane().add(mainPanel);

	}

	protected void initializeFields()
	{
		String srcRoot = config.getSourceCodeRoot();
		if (srcRoot != null) {
			String suffix = File.separator + "src";
			int idx = srcRoot.indexOf(suffix);
			if (idx != -1) {
				srcRoot = srcRoot.substring(0, idx);
			}
		}
		clinicalHomeDirField.setValue(prepareConfigFieldValue(srcRoot, ""));
	}

	protected List<String> checkValidity()
	{
		List<String> invalidList = new ArrayList<String>();
		if (clinicalHomeDirField.getValue().trim().length() == 0) {
			invalidList.add("Java Source Code root path is missing");
		}
		return invalidList;
	}

	protected void prepareErrorMessageDialog(List<String> invalidList)
	{
		StringBuffer msgBuf = new StringBuffer(128);
		msgBuf.append("Please correct the following errors and try again!\n\n");
		for (Iterator<String> iter = invalidList.iterator(); iter.hasNext();) {
			String err = iter.next();
			msgBuf.append('\t').append(err).append("\n");
		}

		CALMHelper.showError(this, msgBuf.toString());
	}

	protected String prepareConfigFieldValue(String fieldValue,
			String defaultValue)
	{
		if (fieldValue == null || fieldValue.trim().length() == 0)
			return defaultValue;
		return fieldValue;
	}

	protected void populateConfig()
	{
		config.setSourceCodeRoot(clinicalHomeDirField.getValue().trim());

		config.setPackageName("clinical.web.game.forms");
		String formBeanName = prepareFormBeanName();
		config.setFormBeanName(formBeanName);
		config.setFormBeanID(prepareFormBeanID(formBeanName));

		config.setSourceCodeRoot(clinicalHomeDirField.getValue().trim()
				+ File.separator + "src");
		StringBuffer sb = new StringBuffer();
		sb.append(clinicalHomeDirField.getValue().trim())
				.append(File.separator);
		sb.append("web").append(File.separator).append("pages").append(
				File.separator);
		sb.append("assessment");

		config.setJspCodeRoot(sb.toString());

		sb = new StringBuffer();
		sb.append(clinicalHomeDirField.getValue().trim())
				.append(File.separator);
		sb.append("web").append(File.separator).append("WEB-INF").append(
				File.separator);
		sb.append("struts-config.xml.template");

		config.setStrutsConfigFile(sb.toString());
		String genCodeDir = System.getProperty("user.dir") + File.separator
				+ "gen";

		if (new File(genCodeDir).exists()) {
			config.setGeneratedCodeDir(genCodeDir);
		}

		config.setStrutsActionRoot(prepareStrutsActionPrefix(formBeanName));

		config.setRelativeJspPath("/pages/assessment");
	}

	protected String prepareFormBeanName()
	{
		AssessmentAssociation aa = AssociationHelper.getInstance().getAsAssoc();
		AssessmentInfo asi = aa.getLeft();
		String name = asi.getName();
		if (name.length() < 15 && name.indexOf(' ') == -1) {
			return GenUtils.toTitleCase(name) + "Form";
		} else {
			StringTokenizer stok = new StringTokenizer(name);
			StringBuffer sb = new StringBuffer();
			while (stok.hasMoreTokens()) {
				String tok = stok.nextToken();
				if (Character.isLetterOrDigit(tok.charAt(0))) {
					sb.append(Character.toUpperCase(tok.charAt(0)));
				}
			}
			return sb.toString() + "Form";
		}
	}

	protected String prepareFormBeanID(String formBeanName)
	{
		int idx = formBeanName.indexOf("Form");
		return formBeanName.substring(0, idx).toLowerCase() + "Form";
	}

	protected String prepareStrutsActionPrefix(String formBeanName)
	{
		String sap = "/man_";
		int idx = formBeanName.indexOf("Form");
		sap += formBeanName.substring(0, idx).toLowerCase();

		return sap;
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				List<String> invalidList = checkValidity();
				if (!invalidList.isEmpty()) {
					prepareErrorMessageDialog(invalidList);
					return;
				} else {
					populateConfig();
				}
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

}