package caslayout.ui;

import java.util.*;

import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MultilineString.java,v 1.11 2008/10/13 23:58:07 bozyurt Exp $
 */
public class MultilineString implements Cloneable {
  protected String text="";
  protected Justification justification;
  protected int gap = 3;
  protected Color textColor;

  public MultilineString() {
     justification = Justification.LEFT_JUSTIFICATION;
  }

  public MultilineString(String text) {
     justification = Justification.LEFT_JUSTIFICATION;
     this.text = text;
  }

  public MultilineString(MultilineString other) {
    text = other.text;
    justification = other.justification;
    gap = other.gap;
  }



//---------------------- setters --------------
  public void setText(String newText) { this.text = newText; }
  public void setJustification(Justification newJustification) { this.justification = newJustification; }
  public void setGap(int newGap) { this.gap = newGap; }
  public void setTextColor(Color color) { this.textColor = color; }
//---------------------- getters --------------
  public String getText() { return this.text; }
  public Justification getJustification() { return this.justification; }
  public int getGap() { return this.gap; }
  public Color getTextColor() { return textColor; }


  public Rectangle2D getBounds(Graphics2D g2) {
     double width = 0, height = 0;

     Font font = g2.getFont();
     FontRenderContext frCtx =  g2.getFontRenderContext();
     StringTokenizer stok = new StringTokenizer(text,"\n");
     while ( stok.hasMoreTokens()) {
       String line = stok.nextToken();
       Rectangle2D r = font.getStringBounds( line, frCtx);
       height += r.getHeight();
       width += Math.max( width, r.getWidth() + 2 * gap );
     }
     return new Rectangle2D.Double(0, 0, width, height);
  }

  /**
   * Draws the text in the bounding rectangle using the current justification and gap information
   * @param g2
   * @param boundingRect
   */
  public void draw(Graphics2D g2, Rectangle2D boundingRect) {
    Font font = g2.getFont();
    FontRenderContext frCtx =  g2.getFontRenderContext();
    Color oldColor = g2.getColor();
    if ( textColor != null)
      g2.setColor( textColor);

    Rectangle2D bounds = getBounds(g2);
    double xLeft = boundingRect.getX();
    double yTop =  boundingRect.getY() + ( boundingRect.getHeight() - bounds.getHeight()) / 2;
    if ( text.indexOf('\n') == -1) {
      // check if line is too long
      /** @todo  */
    }

    StringTokenizer stok = new StringTokenizer(text,"\n");
    while ( stok.hasMoreTokens()) {
       String line = stok.nextToken();
       StyledTextIterator sti = new StyledTextIterator(line, font);

       Rectangle2D r = font.getStringBounds( line, frCtx);
       double x = xLeft + gap;

       double y = yTop - r.getY();
       float x1 = (float) x;
       float y1 = (float) y;
       while ( sti.hasNext()) {
         StyledText st = sti.next();
         Rectangle2D r1 = st.getFont().getStringBounds( st.getText(), frCtx);
         g2.setFont( st.getFont());

         if ( st.getAdornment() == StyledText.UNDERLINE) {
           AttributedString as = new AttributedString(st.getText());
           as.addAttribute(TextAttribute.FONT, st.getFont());
           as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
           AttributedCharacterIterator acIter = as.getIterator();
           g2.drawString(acIter, x1, y1);
         } else {
           g2.drawString(st.getText(), x1, y1);
         }
         x1 += r1.getWidth();
       }
       yTop += r.getHeight();
    }
    g2.setFont(font);
    if ( textColor != null)
      g2.setColor(oldColor);

  }

  public Object clone() {
    return new MultilineString(this);
  }

  public String toString() {
    return getText();
  }


}