package caslayout.ui;

import java.beans.*;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

public class MultilineStringEditor extends PropertyEditorSupport {
  public MultilineStringEditor() {}

  public boolean supportsCustomEditor() { return true; }

  public Component getCustomEditor() {
    final MultilineString ms = (MultilineString) super.getValue();
    final JPanel panel = new JPanel( new BorderLayout(3,3));
    final JTextArea textArea = new JTextArea(5,40);
    textArea.setText( ms.getText() );

    textArea.getDocument().addDocumentListener(
       new DocumentListener() {
           public void insertUpdate(DocumentEvent  evt) {
             ms.setText( textArea.getText());
             firePropertyChange();
           }

           public void removeUpdate(DocumentEvent evt) {
             ms.setText( textArea.getText());
             firePropertyChange();
           }

           public void changedUpdate(DocumentEvent evt) {}

       });
    panel.add( new JScrollPane(textArea) );
    panel.setBorder( BorderFactory.createLineBorder(Color.darkGray) );
    return panel;
  }



}