package caslayout.ui;

import org.jdom.*;
import caslayout.util.*;
/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MultipleCellSpanConstraint.java,v 1.7 2006/03/29 02:25:03 bozyurt Exp $
 */
public class MultipleCellSpanConstraint extends CellConstraint {
  protected int colSpan = 1;
  protected int rowSpan = 1;


  public MultipleCellSpanConstraint() { super(); }

  public MultipleCellSpanConstraint(int rowIdx, int colIdx) {
    this(rowIdx, colIdx, 1, 1);
  }

  public MultipleCellSpanConstraint(int rowIdx, int colIdx, int colSpan, int rowSpan) {
    super(rowIdx, colIdx);
    this.colSpan = colSpan;
    this.rowSpan = rowSpan;
  }


  //---------------------- setters --------------
  public void setColSpan(int newColSpan) { this.colSpan = newColSpan; }
  public void setRowSpan(int newRowSpan) { this.rowSpan = newRowSpan; }
  //---------------------- getters --------------
  public int getColSpan() { return this.colSpan; }
  public int getRowSpan() { return this.rowSpan; }


  /**
   *
   * @param ch the height of the cell assuming every row is spaced equal.
   * @param vGap vertical gap between cells
   * @param totHeight the available total height of the container
   * @return the height of the cell after application of the constraint
   */
  public double calculateHeight(double ch, double vGap, double totHeight) {
    return ch * rowSpan + (rowSpan - 1) * vGap;
  }

  public boolean hasZeroWidth() {
	  return colSpan == 0;
  }


  /**
   *
   * @param cw the width of the cell assuming every row is spaced equal.
   * @param hGap horizontal gap between cells
   * @param totWidth the available total width of the container
   * @return the width of the cell after application of the constraint
   */
  public double calculateWidth(double cw, double hGap, double totWidth) {
    return cw * colSpan + (colSpan - 1) * hGap;
  }




  public boolean equals(MultipleCellSpanConstraint other) {
    if ( other == null || !( other instanceof MultipleCellSpanConstraint) )
      return false;
    MultipleCellSpanConstraint mo = (MultipleCellSpanConstraint) other;
    return ( rowIdx ==  mo.rowIdx   && colIdx == mo.colIdx &&
             colSpan == mo.colSpan && rowSpan == mo.rowSpan );
  }

  public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append("MultipleCellSpanConstraint ::[");
    buf.append("rowIdx=").append(rowIdx).append(",colIdx=").append(colIdx);
    buf.append(",colSpan=").append(colSpan).append(",rowSpan=").append(rowSpan);
    buf.append(']');
    return buf.toString();
  }

  public static MultipleCellSpanConstraint initializeFromXML(Element e) {
    int rowIdx = 0, colIdx = 0, rowSpan = 1, colSpan = 1;
    rowIdx = XMLUtils.getPropertyValue("rowIdx", e, rowIdx);
    colIdx = XMLUtils.getPropertyValue("colIdx", e, colIdx);
    colSpan = XMLUtils.getPropertyValue("colSpan", e, colSpan);
    rowSpan = XMLUtils.getPropertyValue("rowSpan", e, rowSpan);
    MultipleCellSpanConstraint cons = new MultipleCellSpanConstraint(rowIdx, colIdx, colSpan, rowSpan);

    return cons;
  }

  public Element toXML(Element root) {
    Element e = new Element("object");
    e.setAttribute("class", "caslayout.ui.MultipleCellSpanConstraint");
    e.addContent( XMLUtils.prepareProperty("rowIdx", String.valueOf(rowIdx)) );
    e.addContent( XMLUtils.prepareProperty("colIdx", String.valueOf(colIdx)) );
    e.addContent( XMLUtils.prepareProperty("rowSpan", String.valueOf(rowSpan)) );
    e.addContent( XMLUtils.prepareProperty("colSpan", String.valueOf(colSpan)) );
    return e;
  }
}