package caslayout.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PageEditComponent.java,v 1.7 2008/10/13 23:58:07 bozyurt Exp $
 */
public class PageEditComponent extends JPanel implements ActionListener {
	private static final long serialVersionUID = 5986908865690458618L;
	protected JComboBox comboBox;
	protected JButton addButton;
	protected JButton delButton;
	protected List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();
	protected Vector<String> pageNumbers = new Vector<String>();
	protected int lastAction;
	protected int newPageLocation;
	protected int toBeDeletedPageIDx;

	public final static int NONE = 0;
	public final static int ADD_PAGE = 1;
	public final static int CHANGE_PAGE = 2;
	public final static int DELETE_PAGE = 3;

	public final static int BEFORE_CURRENT = 10;
	public final static int AFTER_CURRENT = 11;
	public final static int AS_LAST = 12;

	public PageEditComponent(int numPages) {
		this.lastAction = NONE;
		BoxLayout bl = new BoxLayout(this, BoxLayout.X_AXIS);
		this.setLayout(bl);
		String s = " of " + numPages;
		for (int i = 0; i < numPages; i++) {
			pageNumbers.add(String.valueOf(i + 1) + s);
		}
		comboBox = new JComboBox(pageNumbers);

		comboBox.setPrototypeDisplayValue("99 of 99");
		comboBox.setMaximumSize(comboBox.getMinimumSize());
		String imgLocation = "/images/plus_tr.gif";
		java.net.URL imageURL = ClinicalAssessmentLayoutManager.class
				.getResource(imgLocation);
		if (imageURL == null) {
			addButton = new JButton("Add");
		} else {
			addButton = new JButton(new ImageIcon(imageURL));
		}
		addButton.setMinimumSize(new Dimension(20, 23));
		addButton.setMaximumSize(addButton.getMinimumSize());

		addButton.addActionListener(this);
		imgLocation = "/images/delete.png";
		imageURL = ClinicalAssessmentLayoutManager.class
				.getResource(imgLocation);
		if (imageURL == null) {
			delButton = new JButton("Del");
		} else {
			delButton = new JButton(new ImageIcon(imageURL));
		}
		delButton.setMinimumSize(new Dimension(20, 23));
		delButton.setMaximumSize(delButton.getMinimumSize());

		delButton.addActionListener(this);
		comboBox.addActionListener(this);

		this.add(comboBox);
		this.add(addButton);
		this.add(delButton);
		this.setMaximumSize(getMinimumSize());
	}

	public void changePageNumbers(int numPages)
	{
		if (numPages == pageNumbers.size()) {
			return;
		}
		pageNumbers.clear();
		String s = " of " + numPages;
		for (int i = 0; i < numPages; i++) {
			pageNumbers.add(String.valueOf(i + 1) + s);
		}
		comboBox.setSelectedIndex(0);
	}

	public void addChangeListener(ChangeListener listener)
	{
		changeListeners.add(listener);
	}

	public int getSelectedPageIdx()
	{
		return comboBox.getSelectedIndex();
	}

	public int getLastAction()
	{
		return lastAction;
	}

	public int getNewPageLocation()
	{
		return this.newPageLocation;
	}

	public int getToBeDeletedPageIDx()
	{
		return this.toBeDeletedPageIDx;
	}

	public void actionPerformed(ActionEvent event)
	{
		if (event.getSource() == addButton) {
			String sel = (String) JOptionPane.showInputDialog(this,
					"Add a new page ", "Add a new page",
					JOptionPane.PLAIN_MESSAGE, null, new String[] {
							"Before Current", "After Current",
							"As the last page" }, "After Current");
			if (sel == null) {
				lastAction = NONE;
				return;
			}

			int oldSelIdx = comboBox.getSelectedIndex();
			int numPages = pageNumbers.size() + 1;
			pageNumbers.clear();
			String s = " of " + numPages;
			for (int i = 0; i < numPages; i++) {
				pageNumbers.add(String.valueOf(i + 1) + s);
			}
			comboBox.setSelectedIndex(oldSelIdx);
			if (sel.startsWith("Before")) {
				newPageLocation = BEFORE_CURRENT;
			} else if (sel.startsWith("After")) {
				newPageLocation = AFTER_CURRENT;
			} else if (sel.startsWith("As")) {
				newPageLocation = AS_LAST;
				comboBox.setSelectedIndex(numPages - 1);
			} else {
				newPageLocation = NONE;
			}

			lastAction = ADD_PAGE;
			notifyListeners();
		} else if (event.getSource() == delButton) {
			if (pageNumbers.size() == 1) {
				return;
			}
			// use JOptionPane.YES_NO_CANCEL_OPTION because of the Swing bug
			// (IBO)
			int rc = JOptionPane.showConfirmDialog(this,
					"The current page will be deleted. Are you sure?", "",
					JOptionPane.WARNING_MESSAGE,
					JOptionPane.YES_NO_CANCEL_OPTION);
			// System.out.println("rc = " + rc + " " + JOptionPane.NO_OPTION + "
			// cancel option=" + JOptionPane.CANCEL_OPTION);

			if (rc == JOptionPane.CANCEL_OPTION || rc == JOptionPane.NO_OPTION) {
				return;
			}

			int oldSelIdx = comboBox.getSelectedIndex();
			this.toBeDeletedPageIDx = oldSelIdx;
			if (oldSelIdx + 1 == pageNumbers.size()) {
				oldSelIdx--;
			}
			int numPages = pageNumbers.size() - 1;
			pageNumbers.clear();
			String s = " of " + numPages;
			for (int i = 0; i < numPages; i++) {
				pageNumbers.add(String.valueOf(i + 1) + s);
			}

			comboBox.setSelectedIndex(oldSelIdx);
			lastAction = DELETE_PAGE;
			notifyListeners();
		} else if (event.getSource() == comboBox) {
			lastAction = CHANGE_PAGE;
			notifyListeners();
		}
	}

	private void notifyListeners()
	{
		for (Iterator<ChangeListener> iter = changeListeners.iterator(); iter.hasNext();) {
			ChangeListener cl = iter.next();
			cl.stateChanged(new ChangeEvent(this));
		}
	}
}
