package caslayout.ui;

import org.jdom.Element;

import caslayout.util.XMLUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PercentCellConstraint.java,v 1.3 2006/03/29 02:25:03 bozyurt Exp $
 */

public class PercentCellConstraint extends CellConstraint {
	protected double colPercent;
	protected double rowPercent;

	public PercentCellConstraint() {
		super();
	}

	public PercentCellConstraint(int rowIdx, int colIdx, double colPercent,
			double rowPercent) {
		super(rowIdx, colIdx);
		this.colPercent = colPercent;
		this.rowPercent = rowPercent;
	}

	// ---------------------- setters --------------
	public void setColPercent(double newColPercent)
	{
		this.colPercent = newColPercent;
	}

	public void setRowPercent(double newRowPercent)
	{
		this.rowPercent = newRowPercent;
	}

	// ---------------------- getters --------------
	public double getColPercent()
	{
		return this.colPercent;
	}

	public double getRowPercent()
	{
		return this.rowPercent;
	}

	public boolean hasZeroWidth()
	{
		return colPercent == 0;
	}

	/**
	 * calculates the height of the cell
	 * 
	 * @param ch
	 *            the height of the cell assuming every row is spaced equal.
	 * @param vGap
	 *            vertical gap between cells
	 * @param totHeight
	 *            the available total height of the container
	 * @return the height of the cell after application of the constraint
	 */
	public double calculateHeight(double ch, double vGap, double totHeight)
	{
		return rowPercent * totHeight / 100.0;
	}

	/**
	 * calculates the width of the cell
	 * 
	 * @param cw
	 *            the width of the cell assuming every row is spaced equal.
	 * @param hGap
	 *            horizontal gap between cells
	 * @param totWidth
	 *            the available total width of the container
	 * @return the width of the cell after application of the constraint
	 */
	public double calculateWidth(double cw, double hGap, double totWidth)
	{
		return colPercent * totWidth / 100.0;
	}

	public static double calculatePercentage(double newCellDimVal, double totDimVal)
	{
		return newCellDimVal / totDimVal * 100.0;
	}

	public boolean equals(Object other)
	{
		if (other == this) {
			return true;
		}
		if (!(other instanceof PercentCellConstraint)) {
			return false;
		}
		PercentCellConstraint that = (PercentCellConstraint) other;
		return this.colIdx == that.colIdx && this.rowIdx == that.rowIdx
				&& this.colPercent == that.colPercent
				&& this.rowPercent == that.rowPercent;
	}

	public static PercentCellConstraint initializeFromXML(Element e)
	{
		int rowIdx = 0, colIdx = 0;
		double rowPercent = 0, colPercent = 1;
		rowIdx = XMLUtils.getPropertyValue("rowIdx", e, rowIdx);
		colIdx = XMLUtils.getPropertyValue("colIdx", e, colIdx);
		colPercent = XMLUtils.getPropertyValueDouble("colPercent", e,
				colPercent);
		rowPercent = XMLUtils.getPropertyValueDouble("rowPercent", e,
				rowPercent);
		PercentCellConstraint cons = new PercentCellConstraint(rowIdx, colIdx,
				colPercent, rowPercent);

		return cons;
	}

	public Element toXML(Element root)
	{
		Element e = new Element("object");
		e.setAttribute("class", "caslayout.ui.PercentCellConstraint");
		e
				.addContent(XMLUtils.prepareProperty("rowIdx", String
						.valueOf(rowIdx)));
		e
				.addContent(XMLUtils.prepareProperty("colIdx", String
						.valueOf(colIdx)));
		e.addContent(XMLUtils.prepareProperty("rowPercent", String
				.valueOf(rowPercent)));
		e.addContent(XMLUtils.prepareProperty("colPercent", String
				.valueOf(colPercent)));
		return e;
	}

	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("PercentCellConstraint::[");
		sb.append("colIdx=").append(colIdx).append(",rowIdx=").append(rowIdx);
		sb.append(",colPercent=").append(colPercent).append(".rowPercent=")
				.append(rowPercent);
		sb.append("]");
		return sb.toString();
	}

}