package caslayout.ui;

import guilib.common.BaseDialog;
import guilib.common.NameComboField;
import guilib.common.NameValueField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: QuestionGroupDialog.java,v 1.2.2.2 2007/06/13 23:23:10 bozyurt
 *          Exp $
 */
public class QuestionGroupDialog extends BaseDialog {
	private static final long serialVersionUID = 8459475667396617904L;
	protected NameComboField questionType;
	protected NameValueField minAnswerField;
	protected NameValueField maxAnswerField;
	public final static String REGULAR = "regular";
	public final static String MULTI_ANSWER = "multi-answer";

	public QuestionGroupDialog(Frame owner, String title) {
		super(owner, title, new String[] { "Cancel", "OK" });
		setDefaultButton("Cancel");
		init();
		pack();
	}

	protected void init() {
		JPanel panel = new JPanel(new GridLayout(3, 1));
		panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		questionType = new NameComboField("Question Type:", new String[] {
				REGULAR, MULTI_ANSWER });
		minAnswerField = new NameValueField("Min Answer:", 5);
		maxAnswerField = new NameValueField("MaxAnswer:", 5);
		minAnswerField.setValue("1");
		maxAnswerField.setValue("1");
		panel.add(questionType);
		panel.add(minAnswerField);
		panel.add(maxAnswerField);
		getContentPane().add(panel);
	}

	public String getQuestionType() {
		return questionType.getValue();
	}

	public int getMinAnswer() {
		try {
			return Integer.parseInt(minAnswerField.getValue().trim());
		} catch (NumberFormatException nfe) {
			return 1;
		}
	}

	public int getMaxAnswer() {
		try {
			return Integer.parseInt(maxAnswerField.getValue().trim());
		} catch (NumberFormatException nfe) {
			return 1;
		}
	}

	public void actionPerformed(ActionEvent e) {
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

}