package caslayout.ui;

import java.util.*;
import org.jdom.Element;
import caslayout.ui.model.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: QuestionGroupRepository.java,v 1.9 2007/10/08 18:00:41 bozyurt
 *          Exp $
 */
public class QuestionGroupRepository {
   protected Map<String, QuestionGroup> repositoryMap = null;
   protected Map<String, QuestionGroup> dispCompIDQgMap = null;
   protected int idCount = 0;
   protected static QuestionGroupRepository instance;

   protected QuestionGroupRepository() {
      repositoryMap = Collections
            .synchronizedMap(new HashMap<String, QuestionGroup>());
      dispCompIDQgMap = Collections
            .synchronizedMap(new HashMap<String, QuestionGroup>());
   }

   public synchronized static QuestionGroupRepository getInstance() {
      if (instance == null) {
         instance = new QuestionGroupRepository();
      }
      return instance;
   }

   /**
    * clean all held state
    *
    */
   public synchronized void clear() {
      repositoryMap.clear();
      dispCompIDQgMap.clear();
   }

   public synchronized void populateFromXML(Element e, Document document) {
      List<?> children = e.getChildren("question");
      int maxID = 0;
      // start with a clean slate
      clear();

      for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
         Element ce = (Element) iter.next();
         QuestionGroup qg = QuestionGroup.initializeFromXML(ce, document);
         if (qg == null) {
            // must be an orphan question skip it
            continue;
         }
         int id = Integer.parseInt(qg.getId());
         if (id > maxID)
            maxID = id;
         repositoryMap.put(qg.getId(), qg);
      }
      idCount = maxID;
   }

   public synchronized QuestionGroup createQuestionGroup() {
      ++idCount;
      return new QuestionGroup(String.valueOf(idCount));
   }

   public void add(QuestionGroup qg) {
      repositoryMap.put(qg.getId(), qg);
      updateDispCompIDQgMap(qg);
   }

   protected synchronized void updateDispCompIDQgMap(QuestionGroup qg) {
      for (Iterator<IDisplayComponent> it = qg.getElements().iterator(); it
            .hasNext();) {
         AbstractDisplayComponent adc = (AbstractDisplayComponent) it.next();
         dispCompIDQgMap.put(adc.getId(), qg);
      }
   }

   public synchronized void removeGroup(String groupID) {
      QuestionGroup qg = repositoryMap.remove(groupID);
      for (Iterator<IDisplayComponent> it = qg.getElements().iterator(); it
            .hasNext();) {
         AbstractDisplayComponent adc = (AbstractDisplayComponent) it.next();
         dispCompIDQgMap.remove(adc.getId());
      }
   }

   public QuestionGroup get(String groupID) {
      return repositoryMap.get(groupID);
   }

   public Set<String> getQuestionIDs() {
      return repositoryMap.keySet();
   }

   public synchronized Map<String, String> getQIDScoreNameMap() {
      Map<String, String> qidScoreMap = new LinkedHashMap<String, String>();
      AssociationHelper ah = AssociationHelper.getInstance();
      for (Iterator<QuestionGroup> iter = repositoryMap.values().iterator(); iter
            .hasNext();) {
         QuestionGroup qg = iter.next();
         for (Iterator<IDisplayComponent> it = qg.getElements().iterator(); it
               .hasNext();) {
            AbstractDisplayComponent adc = (AbstractDisplayComponent) it.next();
            ScoreAssociation sa = (ScoreAssociation) ah
                  .findScoreAssociationForDisplayComponent(adc);
            if (sa != null) {

               qidScoreMap.put(qg.getId(), sa.getName());
               break;
            }
         }// it
      }
      return qidScoreMap;
   }

   /**
    *
    * @param idc
    * @return
    */
   public synchronized QuestionGroup findMatching(String compID,
         ScoreAssociation sa) {
      if (compID == null)
         return null;
      for (Iterator<QuestionGroup> iter = repositoryMap.values().iterator(); iter
            .hasNext();) {
         QuestionGroup qg = iter.next();
         for (Iterator<IDisplayComponent> it = qg.getElements().iterator(); it
               .hasNext();) {
            AbstractDisplayComponent adc = (AbstractDisplayComponent) it.next();
            if (sa.getRight() instanceof LogicalGroup) {
               LogicalGroup lg = (LogicalGroup) sa.getRight();
               if (lg.findComponent(adc.getId()) != null) {
                  return qg;
               }
            } else {
               if (adc.getId().equals(compID))
                  return qg;
            }
         }
      }
      return null;
   }

   public synchronized QuestionGroup findMatching(IDisplayComponent idc) {
      if (idc == null) {
         return null;
      }
      if (dispCompIDQgMap.isEmpty()) {
         for (Iterator<QuestionGroup> iter = repositoryMap.values().iterator(); iter
               .hasNext();) {
            QuestionGroup qg = iter.next();
            updateDispCompIDQgMap(qg);
         }
      }

      String theID = ((AbstractDisplayComponent) idc).getId();
      // O(1)
      return dispCompIDQgMap.get(theID);
   }

}
