package caslayout.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Statement;

import org.jdom.Element;

import caslayout.util.GUIUtils;
import caslayout.util.UIDManager;
import caslayout.util.XMLUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: RadioButtonDisplayComponent.java,v 1.16 2005/09/09 01:36:07
 *          bozyurt Exp $
 */

public class RadioButtonDisplayComponent extends AbstractDisplayComponent {
   protected MultilineString label;
   protected String value;

   public RadioButtonDisplayComponent() {
      super();
   }

   public RadioButtonDisplayComponent(String id) {
      super(id);
   }

   public RadioButtonDisplayComponent(String labelText, int x, int y,
         Component peer) {
      super(x, y, peer);
      this.label = new MultilineString();
      this.label.setText(labelText);
   }

   public RadioButtonDisplayComponent(MultilineString label, int x, int y,
         Component peer) {
      super(x, y, peer);
      this.label = label;
      getBounds((Graphics2D) peer.getGraphics());
   }

   public RadioButtonDisplayComponent(RadioButtonDisplayComponent other) {
      super(other);
      this.id = UIDManager.getInstance().getNextUID();
      // super( other.x, other.y, other.peer,
      // UIDManager.getInstance().getNextUID(), other.name,
      // Justification.CENTER_JUSTIFICATION);
      this.label = new MultilineString(other.label);
      getBounds((Graphics2D) peer.getGraphics());
   }

   public void draw(Graphics2D g2) {
      Rectangle2D r = getBounds(g2);
      double circleDia = 6;
      int totGap = 6;

      Color oldColor = g2.getColor();
      if (selected) {
         g2.setColor(Color.blue);
         if (label != null)
            label.setTextColor(Color.blue);
      } else if (groupID != null) {
         g2.setColor(Color.magenta);
         if (label != null)
            label.setTextColor(Color.magenta);

         super.showGroupID(g2, groupID, r, Color.cyan);
      } else {
         if (label != null)
            label.setTextColor(Color.black);
      }

      if (getShowQuestions())
         super.showQuestion(g2, r, Color.ORANGE);

      if (getShowAssociations())
         super.showScoreName(g2, r, Color.cyan);

      if (label.getText().length() > 0) {
         Rectangle2D labelBounds = label.getBounds(g2);
         double offset = (r.getHeight() - labelBounds.getHeight()) / 2;
         double y1 = r.getY() + ((offset >= 0) ? offset : 0);
         circleDia = Math.min(labelBounds.getHeight() - 1, 6);
         double totWidth = circleDia + totGap + labelBounds.getWidth();
         offset = (r.getWidth() - totWidth) / 2;
         // double startX = r.getX() + (( offset >= 0) ? offset : 0);

         Dimension2D compDim = new Dimension((int) totWidth, (int) labelBounds
               .getHeight());
         Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim,
               justification);
         y1 = r.getY() + r.getHeight() / 2 - circleDia / 2;

         label.draw(g2, new Rectangle2D.Double(point.getX() + circleDia
               + totGap, point.getY(), labelBounds.getWidth(), labelBounds
               .getHeight()));

         g2.drawOval((int) (point.getX() + totGap / 2), (int) (y1),
               (int) circleDia, (int) circleDia);
      } else {

         Dimension2D compDim = new Dimension((int) circleDia, (int) circleDia);
         Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim,
               justification);

         g2.drawOval((int) (point.getX()), (int) (point.getY()),
               (int) circleDia, (int) circleDia);
      }
      g2.setColor(oldColor);
   }

   public Rectangle2D getBounds(Graphics2D g2) {
      if (super.bounds == null) {
         Rectangle2D labelBounds = label.getBounds(g2);
         Rectangle2D.Double r = new Rectangle2D.Double(x, y, labelBounds
               .getWidth()
               + labelBounds.getHeight(), labelBounds.getHeight());
         super.bounds = r;
      }
      return super.bounds;
   }

   public String getText() {
      if (label != null) {
         return label.getText();
      } else {
         return "";
      }
   }

   public void setText(String txt) {
      if (label == null) {
         label = new MultilineString(txt);
      } else {
         label.setText(txt);
      }

      // the default value is the user specified text
      if (value == null)
         value = txt;
   }

   public int getGap() {
      if (label != null)
         return label.getGap();
      return 0;

   }

   public void setGap(int newGap) {
      if (label != null)
         label.setGap(newGap);
   }

   public void setValue(String newValue) {
      this.value = newValue;
   }

   public String getValue() {
      return this.value;
   }

   public Object clone() {
      return new RadioButtonDisplayComponent(this);
   }

   public static void setPersistenceDelegate(Encoder encoder) {
      encoder.setPersistenceDelegate(CAGridLayout.class,
            new DefaultPersistenceDelegate() {
               protected void initialize(Class<?> type, Object oldInstance,
                     Object newInstance, Encoder out) {
                  super.initialize(type, oldInstance, newInstance, out);
                  RadioButtonDisplayComponent rdc = (RadioButtonDisplayComponent) oldInstance;
                  try {
                     System.out.println(">> persisting the text label");
                     out.writeStatement(new Statement(oldInstance, "setText",
                           new Object[] { rdc.getText() }));

                  } catch (Exception x) {
                     x.printStackTrace();
                  }
               }
            });
   }

   public static RadioButtonDisplayComponent initializeFromXML(Element e) {
      String text = XMLUtils.getStringPropertyValue("text", e, null);
      String value = XMLUtils.getStringPropertyValue("value", e, null);
      String id = XMLUtils.getStringPropertyValue("id", e, "");
      String justificationValue = XMLUtils.getStringPropertyValue(
            "justification", e, null);
      String cssClass = XMLUtils.getStringPropertyValue("cssClass", e, null);

      RadioButtonDisplayComponent rdc = new RadioButtonDisplayComponent(id);
      if (text != null) {
         rdc.setText(text);
      }
      rdc.x = XMLUtils.getPropertyValue("x", e, 0);
      rdc.y = XMLUtils.getPropertyValue("y", e, 0);
      rdc.width = XMLUtils.getPropertyValue("height", e, 0);
      rdc.height = XMLUtils.getPropertyValue("height", e, 0);
      rdc.value = value;

      rdc.cssClass = cssClass;
      String refID = XMLUtils.getReferencePropertyValue("parent", e, null);
      if (refID != null)
         rdc.parent = (IDisplayComponent) XMLUtils
               .getReferencedObject(refID, e);

      if (justificationValue != null) {
         rdc.setJustification(Justification
               .findJustification(justificationValue));
      }
      return rdc;
   }

   public Element toXML(Element root) {
      Element e = super.toXML(root);
      e.setAttribute("class", "caslayout.ui.RadioButtonDisplayComponent");
      if (label != null)
         e.addContent(XMLUtils.prepareProperty("text", label.getText()));
      if (value != null)
         e.addContent(XMLUtils.prepareProperty("value", value));

      e.addContent(XMLUtils.prepareProperty("justification", justification
            .getValue()));

      return e;
   }
}
