package caslayout.ui;

/**
 * holds information about a user selected (by clicking on an display component).
 * A selected component can be a single display element or a logical group if the
 * selected component belongs to a logical group.
 *
 * @author I. Burak Ozyurt
 * @version $Id: SelectedComponentInfo.java,v 1.3 2006/03/29 02:25:03 bozyurt Exp $
 */
public class SelectedComponentInfo {
  protected IDisplayComponent selectedObject;

  public SelectedComponentInfo(AbstractDisplayComponent selectedObject) {
    this.selectedObject = selectedObject;
  }

  public IDisplayComponent getSelectedObject() { return this.selectedObject; }


  /**
   * returns the logical group (if any) the selected component belongs, otherwise returns null
   * @return the logical group (if any) the selected component belongs, otherwise returns null
   */
  public LogicalGroup findLogicalGroup() {
    return LogicalGroupRepository.getInstance().findMatching( selectedObject );
  }

}