package caslayout.ui;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SelectionCommand.java,v 1.10 2008/10/13 23:58:07 bozyurt Exp $
 */
public class SelectionCommand implements ICommand {
  ScoreLayoutPanel slPanel;
  Rectangle2D rect;
  List<IDisplayComponent> selectedObjects = new LinkedList<IDisplayComponent>();
  boolean found = false;
  protected static Logger log = Logger.getLogger("SelectionCommand");

  public SelectionCommand(ScoreLayoutPanel slPanel, Rectangle2D rect) {
    this.slPanel = slPanel;
    this.rect = rect;
  }

  public void setRect(Rectangle2D r) {
    this.rect = r;
  }

  public void execute() throws CommandException {
    if ( !selectedObjects.isEmpty() ) {
      undo();
    }
    List<CAContainer> displayComponents = slPanel.displayComponents;
    found = false;
    Graphics2D g2 = (Graphics2D) slPanel.getGraphics();
    for (Iterator<CAContainer> iter = displayComponents.iterator(); iter.hasNext(); ) {
      IDisplayComponent ic = (IDisplayComponent)iter.next();
      setAsSelected(g2, ic);
    }
    slPanel.repaint();
    log.info("Selected objects");
    for (Iterator<IDisplayComponent> iter = selectedObjects.iterator(); iter.hasNext(); ) {
      Object item = iter.next();
      log.info(item.toString());
    }
  }


  /** @todo refactor this for more efficient algorithm  */
  protected void setAsSelected(Graphics2D g2, IDisplayComponent parent) {
    log.info("in setAsSelected");
    if ( this.rect == null)
       return;

    if ( parent instanceof CAContainer) {
       CAContainer con = (CAContainer) parent;
       if ( parent.isContained(rect, g2) ) {
         parent.setSelected(true);
         found = true;
         addSelectedObject(parent);
         for (IDisplayComponent child : con.components) {
           if ( child != null) {
             setAsSelected(g2, child);
           }
         }
       } else {
         // select individual display objects
         for (IDisplayComponent child : con.components) {
           if (child != null) {
             if (! (child instanceof CAContainer)) {
                Rectangle2D r = child.getBounds(g2);
                if ( rect.contains(r) ) {
                  child.setSelected(true);
                  addSelectedObject(child);
                }
             } else {
               setAsSelected(g2, child);
             }
           }
         } // for

       }
       if ( !found) {
         for (IDisplayComponent child : con.components) {
           if (child != null) {
             setAsSelected(g2, child);
           }
         }
       }
    } else {
      if ( found && parent.isContained(rect, g2) ) {
         parent.setSelected(true);
         addSelectedObject(parent);
      } else if ( rect.contains( parent.getBounds(g2)) ) {
        parent.setSelected(true);
         addSelectedObject(parent);
      }
    }
  }


  protected void addSelectedObject(IDisplayComponent idc) {
    if ( ! selectedObjects.contains(idc) ) {
      selectedObjects.add( idc );
    }
  }

  public void undo() throws CommandException {
    if ( selectedObjects.isEmpty()) return;
    log.info("SelectionCommand:undo");
    for (Iterator<IDisplayComponent> iter = selectedObjects.iterator(); iter.hasNext(); ) {
      IDisplayComponent ic = iter.next();
      ic.setSelected(false);
    }
    selectedObjects.clear();
    slPanel.repaint();
  }

  public List<IDisplayComponent> getSelectedObjects() { return selectedObjects; }

}