package caslayout.ui;

import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;
import guilib.common.NameValueField;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;

import caslayout.codegen.struts.StrutsCodegenConfig;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StrutsCodeGenParamsDialog.java,v 1.6 2006/03/29 02:25:03
 *          bozyurt Exp $
 */
public class StrutsCodeGenParamsDialog extends BaseDialog {
   private static final long serialVersionUID = 8095321081027060558L;
   protected StrutsCodegenConfig config;
   protected Document doc;
   protected JPanel labelPanel;
   protected JPanel fieldPanel;
   protected NameValueField formBeanField, packageNameField, formBeanIDField,
         relativeJspPathField, strutsActionRootField, appContextField,
         submitReturnField;

   protected FileNameValueField srcCodeRootField, jspCodeRootField,
         strutsConfigFilePathField, genCodeDirField;
   protected JTable pageNamesTable;
   protected PageNamesTableModel model;

   public StrutsCodeGenParamsDialog(Frame owner, String title,
         StrutsCodegenConfig config, Document doc) {
      super(owner, title, new String[] { "Cancel", "OK" });
      setDefaultButton("Cancel");
      this.config = config;
      this.doc = doc;
      init();
      pack();

   }

   protected void init() {
      labelPanel = new JPanel(new GridLayout(11, 1, 5, 5));
      labelPanel.add(new JLabel("Application Context:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Package Name:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Form Bean Name:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Form Bean ID:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Source Code Root:", JLabel.RIGHT));
      labelPanel.add(new JLabel("JSP Code Root:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Struts Config File Path:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Generated Code Directory:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Struts Action Prefix:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Relative JSP Path:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Submit Return Page URL:", JLabel.RIGHT));

      appContextField = new NameValueField(null, 25);
      packageNameField = new NameValueField(null, 25);
      formBeanField = new NameValueField(null, 25);
      formBeanIDField = new NameValueField(null, 25);
      formBeanIDField.getTextField().setEditable(false);
      relativeJspPathField = new NameValueField(null, 25);
      strutsActionRootField = new NameValueField(null, 25);
      strutsActionRootField.getTextField().setEditable(false);
      submitReturnField = new NameValueField(null, 25);

      srcCodeRootField = new FileNameValueField(null, 25,
            FileNameValueField.DIR_ONLY);
      jspCodeRootField = new FileNameValueField(null, 25,
            FileNameValueField.DIR_ONLY);
      strutsConfigFilePathField = new FileNameValueField(null, 25,
            FileNameValueField.FILE_ONLY);
      genCodeDirField = new FileNameValueField(null, 25,
            FileNameValueField.DIR_ONLY);

      InputVerifier verifier = new InputVerifier() {
         public boolean verify(JComponent input) {
            JTextField field = (JTextField) input;
            String text = field.getText();
            boolean rv = (text.length() > 4
                  && Character.isUpperCase(text.charAt(0)) && text
                  .endsWith("Form"));
            if (!rv) {
               Toolkit.getDefaultToolkit().beep();
            }
            return rv;
         }
      };
      formBeanField.getTextField().setInputVerifier(verifier);
      BaseDocumentListener bdl = new BaseDocumentListener(formBeanIDField
            .getTextField());
      formBeanField.getTextField().getDocument().addDocumentListener(bdl);

      StrutsActionPrefixDocumentListener sdl = new StrutsActionPrefixDocumentListener(
            strutsActionRootField.getTextField());
      formBeanField.getTextField().getDocument().addDocumentListener(sdl);

      initializeFields();

      fieldPanel = new JPanel(new GridLayout(11, 1, 5, 5));
      fieldPanel.add(appContextField);
      fieldPanel.add(packageNameField);
      fieldPanel.add(formBeanField);
      fieldPanel.add(formBeanIDField);
      fieldPanel.add(srcCodeRootField);
      fieldPanel.add(jspCodeRootField);
      fieldPanel.add(strutsConfigFilePathField);
      fieldPanel.add(genCodeDirField);
      fieldPanel.add(strutsActionRootField);
      fieldPanel.add(relativeJspPathField);
      fieldPanel.add(submitReturnField);

      JPanel fieldGroupPanel = new JPanel(new BorderLayout(3, 3));
      fieldGroupPanel.add(labelPanel, BorderLayout.WEST);
      fieldGroupPanel.add(fieldPanel);

      String prefix = createJSPNamePrefix();

      model = new PageNamesTableModel(doc.getNumPages(), prefix);
      pageNamesTable = new JTable(model);
      pageNamesTable.setPreferredScrollableViewportSize(new Dimension(220, 80));

      TableDocumentListener tdl = new TableDocumentListener(pageNamesTable);
      formBeanField.getTextField().getDocument().addDocumentListener(tdl);

      JPanel pageNamesPanel = new JPanel(new BorderLayout(5, 5));
      pageNamesPanel.setBorder(BorderFactory
            .createTitledBorder("Generated JSP Names"));
      pageNamesPanel.add(new JScrollPane(pageNamesTable));

      JPanel mainPanel = new JPanel(new BorderLayout(3, 3));
      mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      mainPanel.add(fieldGroupPanel);
      mainPanel.add(pageNamesPanel, BorderLayout.SOUTH);

      getContentPane().add(mainPanel);
   }

   protected String createJSPNamePrefix() {
      String prefix = formBeanField.getValue().trim();
      if (prefix.length() > 0) {
         if (prefix.endsWith("Bean") || prefix.endsWith("bean")) {
            prefix = prefix.substring(0, prefix.length() - 4);
         }
      } else if (doc.getName() != null && doc.getName().trim().length() > 0) {
         // try to makeup a prefix from the document name
         // remove any suffix
         prefix = doc.getName();
         int idx = prefix.indexOf('.');
         if (idx != -1) {
            prefix = prefix.substring(0, idx);
         }
      } else {
         prefix = "CALMForm";
      }
      return prefix;
   }

   protected void initializeFields() {
      appContextField.setValue(prepareConfigFieldValue(config.getAppContext(),
            "/clinical"));
      packageNameField.setValue(prepareConfigFieldValue(
            config.getPackageName(), "clinical.web.game.forms"));
      formBeanField.setValue(prepareConfigFieldValue(config.getFormBeanName(),
            ""));
      formBeanIDField.setValue(prepareConfigFieldValue(config.getFormBeanID(),
            ""));
      srcCodeRootField.setValue(prepareConfigFieldValue(config
            .getSourceCodeRoot(), ""));
      jspCodeRootField.setValue(prepareConfigFieldValue(
            config.getJspCodeRoot(), ""));
      strutsConfigFilePathField.setValue(prepareConfigFieldValue(config
            .getStrutsConfigFile(), ""));
      genCodeDirField.setValue(prepareConfigFieldValue(config
            .getGeneratedCodeDir(), ""));
      strutsActionRootField.setValue(prepareConfigFieldValue(config
            .getStrutsActionRoot(), ""));
      relativeJspPathField.setValue(prepareConfigFieldValue(config
            .getRelativeJspPath(), "/pages/assessment/"));
      submitReturnField.setValue(prepareConfigFieldValue(config
            .getSubmitReturnPage(), "/pages/SegmentMan_full.jsp"));
   }

   protected List<String> checkValidity() {
      List<String> invalidList = new ArrayList<String>();
      if (appContextField.getValue().trim().length() == 0)
         invalidList.add("Application Context is missing");
      if (packageNameField.getValue().trim().length() == 0)
         invalidList.add("Package Name is missing");
      if (formBeanField.getValue().trim().length() == 0)
         invalidList.add("Form Bean Name is missing");
      if (formBeanIDField.getValue().trim().length() == 0)
         invalidList.add("Form Bean ID is missing");
      if (srcCodeRootField.getValue().trim().length() == 0)
         invalidList.add("Java Source Code root path is missing");
      if (jspCodeRootField.getValue().trim().length() == 0)
         invalidList.add("JSP Source Code root path is missing");
      if (strutsConfigFilePathField.getValue().trim().length() == 0)
         invalidList.add("Struts Configuration File path is missing");
      if (genCodeDirField.getValue().trim().length() == 0)
         invalidList.add("Generated Code Directory path is missing");
      if (strutsActionRootField.getValue().trim().length() == 0)
         invalidList.add("Struts action tag prefix is missing");
      if (relativeJspPathField.getValue().trim().length() == 0)
         invalidList.add("Relative JSP path is missing");
      if (submitReturnField.getValue().trim().length() == 0)
         invalidList.add("Submit Return Page value is missing");
      return invalidList;
   }

   protected void prepareErrorMessageDialog(List<String> invalidList) {
      StringBuffer msgBuf = new StringBuffer(128);
      msgBuf.append("Please correct the following errors and try again!\n\n");
      for (String err : invalidList) {
         msgBuf.append('\t').append(err).append("\n");
      }

      CALMHelper.showError(this, msgBuf.toString());
   }

   protected String prepareConfigFieldValue(String fieldValue,
         String defaultValue) {
      if (fieldValue == null || fieldValue.trim().length() == 0)
         return defaultValue;
      return fieldValue;
   }

   protected void populateConfig() {
      String str = appContextField.getValue().trim();
      if (!str.startsWith("/"))
         str = "/" + str;
      config.setAppContext(str);
      config.setPackageName(packageNameField.getValue().trim());
      config.setFormBeanName(formBeanField.getValue().trim());
      config.setFormBeanID(formBeanIDField.getValue().trim());
      config.setSourceCodeRoot(srcCodeRootField.getValue().trim());
      config.setJspCodeRoot(jspCodeRootField.getValue().trim());
      config.setStrutsConfigFile(strutsConfigFilePathField.getValue().trim());
      config.setGeneratedCodeDir(genCodeDirField.getValue().trim());
      config.setSubmitReturnPage(submitReturnField.getValue().trim());
      String s = strutsActionRootField.getValue().trim();
      if (!s.startsWith("/")) {
         s = "/" + s;
      }
      config.setStrutsActionRoot(s);
      config.setRelativeJspPath(relativeJspPathField.getValue().trim());
      String[] jspNames = new String[model.getRowCount()];
      for (int i = 0; i < jspNames.length; i++) {
         jspNames[i] = (String) model.getValueAt(i, 1);
      }
      config.setJspPageNames(jspNames);

   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            List<String> invalidList = checkValidity();
            if (!invalidList.isEmpty()) {
               prepareErrorMessageDialog(invalidList);
               return;
            } else {
               populateConfig();
            }
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

   class BaseDocumentListener implements DocumentListener {
      protected JTextField field;

      public BaseDocumentListener(JTextField field) {
         this.field = field;
      }

      public void insertUpdate(DocumentEvent e) {
         setField(e);
      }

      protected void setField(DocumentEvent e) {
         try {
            String text = e.getDocument().getText(0,
                  e.getDocument().getLength());
            if (text.length() > 4) {
               field.setBackground(Color.WHITE);
               String prefix = text.substring(0, text.length() - 4);
               field.setText(prefix.toLowerCase() + "Form");
            } else {
               field.setBackground(Color.RED);
            }
         } catch (BadLocationException e1) {
            e1.printStackTrace();
         }
      }

      public void removeUpdate(DocumentEvent e) {
         setField(e);
      }

      public void changedUpdate(DocumentEvent e) {
         setField(e);
      }
   }// ;

   class StrutsActionPrefixDocumentListener extends BaseDocumentListener {
      public StrutsActionPrefixDocumentListener(JTextField field) {
         super(field);
      }

      protected void setField(DocumentEvent e) {
         try {
            String text = e.getDocument().getText(0,
                  e.getDocument().getLength());
            if (text.length() > 4) {
               field.setBackground(Color.WHITE);
               String prefix = text.substring(0, text.length() - 4);
               field.setText("/man_" + prefix.toLowerCase());
            } else {
               field.setBackground(Color.RED);
            }
         } catch (BadLocationException e1) {
            e1.printStackTrace();
         }
      }
   }// ;

   class TableDocumentListener implements DocumentListener {
      protected JTable table;

      public TableDocumentListener(JTable table) {
         this.table = table;
      }

      public void insertUpdate(DocumentEvent e) {
         updateTable(e);
      }

      protected void updateTable(DocumentEvent e) {
         try {
            String text = e.getDocument().getText(0,
                  e.getDocument().getLength());
            if (text.length() > 4) {
               table.setBackground(Color.WHITE);
               String prefix = text.substring(0, text.length() - 4);
               ((PageNamesTableModel) table.getModel()).update(prefix);
            } else {
               table.setBackground(Color.RED);
            }
         } catch (BadLocationException e1) {
            e1.printStackTrace();
         }
      }

      public void removeUpdate(DocumentEvent e) {
         updateTable(e);
      }

      public void changedUpdate(DocumentEvent e) {
         updateTable(e);
      }
   }

   class PageNamesTableModel extends AbstractTableModel {
      private static final long serialVersionUID = 1602291315083745959L;
      private String[] columnNames;
      private Object[][] data;

      public PageNamesTableModel(int numPages, String pageNamePrefix) {
         this.columnNames = new String[] { "Description", "JSP Page Name" };
         data = new Object[numPages][2];
         for (int i = 0; i < numPages; i++) {
            String desc = "For page " + (i + 1) + " of assessment form";
            String jspName = pageNamePrefix;
            if (numPages > 1) {
               int idx = jspName.lastIndexOf(".jsp");
               if (idx != -1) {
                  jspName = jspName.substring(0, idx);
               }
               jspName += "_Page" + (i + 1) + ".jsp";
            } else {
               int idx = jspName.lastIndexOf(".jsp");
               if (idx == -1) {
                  jspName += ".jsp";
               }
            }
            data[i][0] = desc;
            data[i][1] = jspName;
         }
      }

      public void update(String pageNamePrefix) {
         if (data.length == 1) {
            String jspName = pageNamePrefix;
            int idx = jspName.lastIndexOf(".jsp");
            if (idx == -1) {
               jspName += ".jsp";
            }
         } else {
            for (int i = 0; i < data.length; i++) {
               String jspName = pageNamePrefix;
               int idx = jspName.lastIndexOf(".jsp");
               if (idx != -1) {
                  jspName = jspName.substring(0, idx);
               }
               jspName += "_Page" + (i + 1) + ".jsp";
               data[i][1] = jspName;
            }
         }
         fireTableRowsUpdated(0, data.length - 1);
      }

      public int getRowCount() {
         return data.length;
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         return data[row][col];
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public Class<?> getColumnClass(int col) {
         return getValueAt(0, col).getClass();
      }

      public boolean isCellEditable(int row, int col) {
         return false;
      }

      public void setValueAt(Object value, int row, int col) {
         data[row][col] = value;
         fireTableCellUpdated(row, col);
      }
   }

}
