package caslayout.ui;

import java.awt.*;

/**
 * Represents a part of a line of text with same style
 * @author I. Burak Ozyurt
 * @version $Id: StyledText.java,v 1.2 2004/06/28 20:55:30 bozyurt Exp $
 */
public class StyledText {
  protected String text;
  protected Font font;
  protected int adornment;
  public final static int UNDERLINE = 1;
  public final static int NONE = 0;


  public StyledText(String text, Font font, int adornment) {
    this.text = text;
    this.font = font;
    this.adornment = adornment;
  }

  public String getText() { return this.text; }
  public Font getFont() { return this.font; }
  public int getAdornment() { return this.adornment; }

  public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append("StyledText ::[");
    buf.append("text=").append(text).append(",font=").append(font);
    buf.append(']');
    return buf.toString();
  }
}