package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TemplateDialog.java,v 1.4 2008/10/13 23:58:07 bozyurt Exp $
 */
public class TemplateDialog extends BaseDialog {
   private static final long serialVersionUID = 8643899480569105539L;
   Vector<String> templateList;
   JList listBox;

   public TemplateDialog(Frame owner, String title, Vector<String> templateList) {
      super(owner, title, new String[] { "Cancel", "Add" });
      setDefaultButton("Cancel");
      this.templateList = templateList;
      init();
      pack();
   }

   protected void init() {
      JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
      mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      listBox = new JList(templateList);
      listBox.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
      if (!templateList.isEmpty()) {
         listBox.setSelectedIndex(0);
      }
      JScrollPane scrollPane = new JScrollPane(listBox);
      mainPanel.add(scrollPane);
      mainPanel.add(scrollPane);
      mainPanel.setBorder(BorderFactory.createTitledBorder("Templates"));
      getContentPane().add(mainPanel);
   }

   public String getSelectedTemplateName() {
      return (String) listBox.getSelectedValue();
   }

   public void actionPerformed(ActionEvent event) {
      returnCode = BaseDialog.CANCEL_PRESSED;
      if (event.getSource() instanceof JButton) {
         JButton button = (JButton) event.getSource();
         if (button.getText().equalsIgnoreCase("add")) {
            returnCode = BaseDialog.OK_PRESSED;
         }
      }
      setVisible(false);
   }

}