package caslayout.ui;

import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;

import org.jdom.*;
import caslayout.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TextAreaDisplayComponent.java,v 1.3 2005/09/09 01:36:07 bozyurt Exp $
 */
public class TextAreaDisplayComponent extends AbstractDisplayComponent {
  protected int numCols = 20;
  protected int numRows = 3;

  public TextAreaDisplayComponent() {
    super();
    this.justification = Justification.LEFT_JUSTIFICATION;
  }

  public TextAreaDisplayComponent(String id) { super(id);
    this.justification = Justification.LEFT_JUSTIFICATION;
  }

  public TextAreaDisplayComponent(int x, int y, Component peer) {
    this(x,y, peer, 20, 3);
    this.justification = Justification.LEFT_JUSTIFICATION;
  }

  public TextAreaDisplayComponent(int x, int y, Component peer, int numCols, int numRows) {
    super(x, y, peer);
    this.numCols = numCols;
    this.numRows = numRows;
    this.justification = Justification.LEFT_JUSTIFICATION;
  }

  public TextAreaDisplayComponent( TextAreaDisplayComponent other) {
    super(other);
    this.id = UIDManager.getInstance().getNextUID();
    this.numCols = other.numCols;
    this.numRows = other.numRows;
  }

  public Object clone() {
    return new TextAreaDisplayComponent(this);
  }


//---------------------- setters --------------
  public void setNumCols(int newNumCols) { this.numCols = newNumCols; }
  public void setNumRows(int newNumRows) { this.numRows = newNumRows; }
//---------------------- getters --------------
  public int getNumCols() { return this.numCols; }
  public int getNumRows() { return this.numRows; }

  public void draw(Graphics2D g2) {
    int margin = 2;
    double boxHeight, boxWidth;

    Rectangle2D r = getBounds(g2);
    Color oldColor = g2.getColor();

    if (getShowQuestions() )
      super.showQuestion(g2, r, Color.ORANGE);
    if ( getShowAssociations() )
      super.showScoreName(g2, r, Color.cyan);

    Font font = g2.getFont();
    FontRenderContext frCtx =  g2.getFontRenderContext();
    Rectangle2D strRect = font.getStringBounds( "AHy", frCtx);

    boxHeight = Math.max( r.getHeight() - 10, strRect.getHeight() + 2);
    boxWidth =  Math.max( r.getWidth() - 20, 20);

    Dimension2D compDim = new Dimension((int) boxWidth, (int) boxHeight);
    Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim, justification);

    Rectangle2D.Double boundingBox = new Rectangle2D.Double( point.getX(), point.getY(), boxWidth, boxHeight);

    g2.setPaint(Color.lightGray);
    g2.fill(boundingBox);

    Rectangle2D.Double fieldBox = new Rectangle2D.Double(point.getX() + margin, point.getY() + margin,
        boxWidth - 2 * margin, boxHeight - 2* margin);

    g2.setPaint(Color.white);
    g2.fill(fieldBox);
    if ( selected ) {
      g2.setColor(Color.blue);
    } else {
      g2.setColor(oldColor);
    }
    g2.draw(fieldBox);
    g2.setColor(oldColor);
  }

  public Rectangle2D getBounds(Graphics2D g2) {
    if (super.bounds == null) {
      Rectangle rb = peer.getBounds();
      Rectangle2D.Double r = new Rectangle2D.Double(x + 3, y + 3,
          rb.getWidth() - 6, rb.getHeight() - 6);

      super.bounds = r;
    }
    return super.bounds;
  }


  public static TextAreaDisplayComponent initializeFromXML(Element e) {
      int numCols = XMLUtils.getPropertyValue("numCols", e, 10);
      int numRows = XMLUtils.getPropertyValue("numRows", e, 10);
      String id = XMLUtils.getStringPropertyValue("id", e, "");
      String cssClass = XMLUtils.getStringPropertyValue("cssClass", e, null);

      TextAreaDisplayComponent tdc = new TextAreaDisplayComponent(id);
      tdc.numCols = numCols;
      tdc.numRows = numRows;

      tdc.x = XMLUtils.getPropertyValue("x", e, 0);
      tdc.y = XMLUtils.getPropertyValue("y", e, 0);
      tdc.width = XMLUtils.getPropertyValue("height", e, 0);
      tdc.height = XMLUtils.getPropertyValue("height", e, 0);
      String justificationValue = XMLUtils.getStringPropertyValue("justification", e, null);
      if ( justificationValue != null) {
        tdc.setJustification( Justification.findJustification(justificationValue) );
      }
      tdc.cssClass = cssClass;
      String refID = XMLUtils.getReferencePropertyValue("parent", e, null);
      if ( refID != null)
        tdc.parent = (IDisplayComponent) XMLUtils.getReferencedObject(refID, e);
      return tdc;
    }



  public Element toXML(Element root) {
    Element e = super.toXML(root);
    e.setAttribute("class","caslayout.ui.TextAreaDisplayComponent");
    e.addContent( XMLUtils.prepareProperty("numCols", String.valueOf(numCols) ) );
    e.addContent( XMLUtils.prepareProperty("numRows", String.valueOf(numRows) ) );
    e.addContent( XMLUtils.prepareProperty("justification", justification.getValue()) );
    return e;
  }
}