package caslayout.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.jdom.Element;

import caslayout.util.GUIUtils;
import caslayout.util.UIDManager;
import caslayout.util.XMLUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: TextFieldDisplayComponent.java,v 1.12 2007/10/08 18:00:41 bozyurt Exp $
 */
public class TextFieldDisplayComponent extends AbstractDisplayComponent {
	protected int fieldLength;
	protected int maxFieldLength = 10;
	protected Expression expression = new Expression(this);

	public TextFieldDisplayComponent() {
		super();
		this.justification = Justification.LEFT_JUSTIFICATION;
	}

	public TextFieldDisplayComponent(String id) {
		super(id);
		this.justification = Justification.LEFT_JUSTIFICATION;	
	}

	public TextFieldDisplayComponent(int x, int y, Component peer) {
		this(x, y, peer, 10);
		this.justification = Justification.LEFT_JUSTIFICATION;
	}

	public TextFieldDisplayComponent(int x, int y, Component peer,
			int fieldLength) {
		super(x, y, peer);
		this.fieldLength = fieldLength;
		this.maxFieldLength = fieldLength;
		this.justification = Justification.LEFT_JUSTIFICATION;
	}

	public TextFieldDisplayComponent(TextFieldDisplayComponent other) {
		super(other);
		this.id = UIDManager.getInstance().getNextUID();
		// super(other.x, other.y, other.peer,
		// UIDManager.getInstance().getNextUID(), other.name,
		// Justification.LEFT_JUSTIFICATION);
		this.fieldLength = other.fieldLength;
		this.maxFieldLength = other.maxFieldLength;
	}

	public Object clone()
	{
		return new TextFieldDisplayComponent(this);
	}

	// ---------------------- setters --------------
	public void setFieldLength(int newFieldLength)
	{
		this.fieldLength = newFieldLength;
	}

	public void setMaxFieldLength(int newMaxFieldLength)
	{
		this.maxFieldLength = newMaxFieldLength;
	}


	// ---------------------- getters --------------
	public int getFieldLength()
	{
		return this.fieldLength;
	}

	public int getMaxFieldLength()
	{
		return this.maxFieldLength;
	}

	public Expression getExpression()
	{
		return expression;
	}

	public void draw(Graphics2D g2)
	{
		int margin = 2;
		double boxHeight, boxWidth;

		Rectangle2D r = getBounds(g2);
		Color oldColor = g2.getColor();

		if (getShowQuestions())
			super.showQuestion(g2, r, Color.ORANGE);
		if (getShowAssociations())
			super.showScoreName(g2, r, Color.cyan);

		Font font = g2.getFont();
		FontRenderContext frCtx = g2.getFontRenderContext();
		Rectangle2D strRect = font.getStringBounds("AHy", frCtx);

		boxHeight = Math.min(r.getHeight(), strRect.getHeight() + 2);
		boxWidth = Math.min(r.getWidth(), 80);

		Dimension2D compDim = new Dimension((int) boxWidth, (int) boxHeight);
		Point2D point = GUIUtils.calculateAlignmentPosition(r, compDim,
				justification);

		Rectangle2D.Double boundingBox = new Rectangle2D.Double(point.getX(),
				point.getY(), boxWidth, boxHeight);

		g2.setPaint(Color.lightGray);
		g2.fill(boundingBox);

		Rectangle2D.Double fieldBox = new Rectangle2D.Double(point.getX()
				+ margin, point.getY() + margin, boxWidth - 2 * margin,
				boxHeight - 2 * margin);

		g2.setPaint(Color.white);
		g2.fill(fieldBox);
		if (selected) {
			g2.setColor(Color.blue);
		} else {
			g2.setColor(oldColor);
		}
		g2.draw(fieldBox);
		g2.setColor(oldColor);
	}

	public Rectangle2D getBounds(Graphics2D g2)
	{
		if (super.bounds == null) {
			Rectangle rb = peer.getBounds();
			Rectangle2D.Double r = new Rectangle2D.Double(x + 3, y + 3, rb
					.getWidth() - 6, rb.getHeight() - 6);

			super.bounds = r;
		}
		return super.bounds;
	}

	public static TextFieldDisplayComponent initializeFromXML(Element e)
	{
		int fieldLength = XMLUtils.getPropertyValue("fieldLength", e, 10);
		int maxFieldLength = XMLUtils.getPropertyValue("maxFieldLength", e, 10);
		String id = XMLUtils.getStringPropertyValue("id", e, "");
		String cssClass = XMLUtils.getStringPropertyValue("cssClass", e, null);

		TextFieldDisplayComponent tdc = new TextFieldDisplayComponent(id);
		tdc.fieldLength = fieldLength;
		tdc.maxFieldLength = maxFieldLength;

		tdc.x = XMLUtils.getPropertyValue("x", e, 0);
		tdc.y = XMLUtils.getPropertyValue("y", e, 0);
		tdc.width = XMLUtils.getPropertyValue("height", e, 0);
		tdc.height = XMLUtils.getPropertyValue("height", e, 0);
		String justificationValue = XMLUtils.getStringPropertyValue(
				"justification", e, null);
		if (justificationValue != null) {
			tdc.setJustification(Justification
					.findJustification(justificationValue));
		}
		String exprValue = XMLUtils.getStringPropertyValue("expression", e, null);
		if ( exprValue != null) {
			tdc.getExpression().setExprString( exprValue );
		}
		
		tdc.cssClass = cssClass;
		String refID = XMLUtils.getReferencePropertyValue("parent", e, null);
		if (refID != null)
			tdc.parent = (IDisplayComponent) XMLUtils.getReferencedObject(
					refID, e);
		return tdc;
	}

	public Element toXML(Element root)
	{
		Element e = super.toXML(root);
		e.setAttribute("class", "caslayout.ui.TextFieldDisplayComponent");
		e.addContent(XMLUtils.prepareProperty("fieldLength", String
				.valueOf(fieldLength)));
		e.addContent(XMLUtils.prepareProperty("maxFieldLength", String
				.valueOf(maxFieldLength)));
		e.addContent(XMLUtils.prepareProperty("justification", justification
				.getValue()));
		if (expression != null && expression.getExprString().trim().length() > 0) {
			e.addContent(XMLUtils.prepareProperty("expression", expression.getExprString().trim()) );
		}
		return e;
	}

}