package caslayout.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.StringReader;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.calc.AsScoreTreePanel;
import caslayout.ui.calc.ExpressionLexer;
import caslayout.ui.calc.ExpressionPanel;
import caslayout.ui.calc.ExpressionParser;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.Association;
import caslayout.ui.model.AssociationHelper;
import caslayout.ui.model.ScoreAssociation;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: TextFieldDisplayComponentCustomizer.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class TextFieldDisplayComponentCustomizer extends JPanel implements
		Customizer, ActionListener {
	private static final long serialVersionUID = -60516286107407279L;
	protected PropertyEditorPanel pep;
	protected TextFieldDisplayComponent textField;
	protected JButton doneButton;
	protected ExpressionPanel exprPanel;
	protected JLabel exprLabel;

	public TextFieldDisplayComponentCustomizer() {
		super(new BorderLayout(5, 5));
		setBorder(BorderFactory.createTitledBorder("Text Field Properties"));
	}

	void showExpressionBuilderPanel()
	{
		AssociationHelper asHelper = AssociationHelper.getInstance();
		AssessmentAssociation aa = asHelper.getAsAssoc();
		if (aa == null)
			return;

		AsScoreTreePanel treePanel;
		JPanel controlPanel = new JPanel(new BorderLayout(3, 3));

		JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
		mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		Association a = (Association) asHelper
				.findScoreAssociationForDisplayComponent(this.textField);
		String calcScoreName = null;
		if (a != null && (a instanceof ScoreAssociation)) {
			ScoreAssociation sa = (ScoreAssociation) a;
			calcScoreName = sa.getName();
		}

		treePanel = new AsScoreTreePanel(asHelper, calcScoreName);
		exprPanel = new ExpressionPanel();
		// exprPanel.addDocumentListener( this.textField.getExpression());
		exprPanel.setExpressionValue(this.textField.getExpression()
				.getExprString());

		controlPanel.add(exprPanel);
		doneButton = new JButton("Validate Expression");
		JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 3, 3));
		JPanel labelPanel = new JPanel();
		labelPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
		BoxLayout bl = new BoxLayout(labelPanel, BoxLayout.X_AXIS);
		labelPanel.setLayout(bl);
		labelPanel.add(new JLabel("Expr: "));
		labelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
		exprLabel = new JLabel(this.textField.getExpression().getExprString());

		labelPanel.add(exprLabel);
		buttonPanel.add(labelPanel);
		JPanel p = new JPanel(new FlowLayout());
		p.add(doneButton);
		buttonPanel.add(p);

		controlPanel.add(buttonPanel, BorderLayout.SOUTH);
		doneButton.addActionListener(this);

		mainPanel.add(treePanel);
		mainPanel.add(controlPanel, BorderLayout.SOUTH);
		add(mainPanel);
		this.validate();
		this.repaint();
	}

	public void setObject(Object bean)
	{
		this.textField = (TextFieldDisplayComponent) bean;
		try {
			pep = new PropertyEditorPanel(this.textField, false);
			this.add(pep, BorderLayout.NORTH);
			showExpressionBuilderPanel();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == doneButton) {
			String exprStr = exprPanel.getExprValue().trim();
			if (exprStr.length() == 0)
				return;
			if (!exprStr.endsWith(";")) {
				exprStr += ";";
			}
			StringReader in = new StringReader(exprStr);
			ExpressionLexer lexer = new ExpressionLexer(in);
			ExpressionParser parser = new ExpressionParser(lexer);
			try {
				parser.expr();
				this.textField.getExpression().setExprString(
						exprPanel.getExprValue().trim());
				this.exprLabel.setText(exprPanel.getExprValue().trim());
			} catch (Exception x) {
				CALMHelper.showError(this, x.toString(),
						"Expression Error");
			}
		}
	}

}
