package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.CheckBoxDisplayComponent;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.MultilineString;
import caslayout.ui.PropertyDialog;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddCheckBoxAdapter.java,v 1.1.2.1 2007/06/11 21:25:53 bozyurt
 *          Exp $
 */
public class AddCheckBoxAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 2170456725309800191L;

	public AddCheckBoxAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();
		CheckBoxDisplayComponent cb = new CheckBoxDisplayComponent(
				new MultilineString(""), 0, 0, layoutPanel);
		try {
			PropertyEditorPanel aPEPanel = new PropertyEditorPanel(cb);
			PropertyDialog pd = new PropertyDialog(this.manager,
					"Add Check Box", aPEPanel);
			int rc = pd.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(cb);
				this.manager.getStatusBar().setText(
						"Click anywhere on the layout to insert a check box");
			}
			pd.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}