package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import caslayout.ui.CAGridLayout;
import caslayout.ui.CAGridLayoutCustomizer;
import caslayout.ui.CAPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddContainerAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AddContainerAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 5799877118897939282L;

	public AddContainerAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = manager.getSlPanel();

		try {
			CAGridLayout gl = null;
			// always use percentages
			boolean usePercentages = true;
			gl = new CAGridLayout(1, 2, usePercentages);
			CAGridLayoutCustomizer customizer = new CAGridLayoutCustomizer();
			customizer.setObject(gl);
			customizer.init();
			JOptionPane.showMessageDialog(layoutPanel, customizer,
					"Container Layout", JOptionPane.PLAIN_MESSAGE);

			CAGridLayout clone = new CAGridLayout(gl);
			CAPanel panel = new CAPanel(clone, 0, 0, 0, 0);
			layoutPanel.setSelectedComponent(panel);

		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}