package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.ui.CALMHelper;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.DropdownDisplayComponent;
import caslayout.ui.DropdownEditDialog;
import caslayout.ui.DynamicDropdownEditDialog;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddDropdownAdapter.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class AddDropdownAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -2212538166059458140L;

	public AddDropdownAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		try {
			ScoreLayoutPanel layoutPanel = manager.getSlPanel();

			String selection = CALMHelper
					.showDropdownTypeSelectionDialog(layoutPanel);
			Map<String, String> labelValueMap = null;
			// if Cancel is pressed
			if (selection == null) {
				return;
			}

			if (selection.equals("Informant")) {
				labelValueMap = CALMHelper.getInformantOptionsMap();
			} else {
				labelValueMap = new LinkedHashMap<String, String>(11);
			}

			DropdownDisplayComponent ddc = new DropdownDisplayComponent(
					labelValueMap, 0, 0, layoutPanel);
			DropdownEditDialog dlg = null;
			if (selection.equalsIgnoreCase("dynamic")) {
				dlg = new DynamicDropdownEditDialog(manager, "Add dropdown",
						ddc);
			} else {
				dlg = new DropdownEditDialog(manager, "Add dropdown", ddc);
			}
			dlg.setLocationRelativeTo(layoutPanel);
			int rc = dlg.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(ddc);
				manager.getStatusBar().setText(
						"Click anywhere on the layout to insert dropdown box");
			}
			dlg.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}