package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.PropertyDialog;
import caslayout.ui.RadioButtonDisplayComponent;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddRadioButtonAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AddRadioButtonAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -4881881656005388526L;

	public AddRadioButtonAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();
		RadioButtonDisplayComponent rb = new RadioButtonDisplayComponent(
				"", 0, 0, layoutPanel);
		try {
			PropertyEditorPanel aPEPanel = new PropertyEditorPanel(rb);
			PropertyDialog pd = new PropertyDialog(
					this.manager,	"Add Radio Button", aPEPanel);
			int rc = pd.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(rb);
				this.manager.getStatusBar()
						.setText("Click anywhere on the layout to insert a radio button");

			}
			pd.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}