package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.ui.CALMHelper;
import caslayout.ui.CAPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.TemplateDialog;
import caslayout.util.GUIUtils;
import caslayout.util.GenUtils;
import caslayout.util.XMLUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddTemplateAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AddTemplateAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -6488799228889006153L;

	public AddTemplateAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();
		TemplateDialog dlg = new TemplateDialog(
				this.manager, "Add Template",
				this.manager.getTemplateList() );
		int rc = dlg.showDialog();
		if (rc == BaseDialog.OK_PRESSED) {
			String tempScreenName = dlg.getSelectedTemplateName();
			String tempFile = GUIUtils.prepareTemplateFilename(
					tempScreenName, this.manager.getConfig().getTemplateDir());
			try {
				CAPanel template = XMLUtils.loadPanel(tempFile, layoutPanel);
				GenUtils.setUIDs(template);
				layoutPanel.setSelectedComponent(template);
			} catch (Exception x) {
				CALMHelper.showError(layoutPanel, x.getMessage(), "Error while loading template");					
				x.printStackTrace();
				ClinicalAssessmentLayoutManager.getLog().error("prepareTemplateSelector", x);
			}

		}
		dlg.dispose();
		GUIUtils.showStatusMessage(layoutPanel, "");
	}
}