package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.MultilineString;
import caslayout.ui.PropertyDialog;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.TextDisplayComponent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddTextAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class AddTextAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 5228170232206044406L;

	public AddTextAdapter(ClinicalAssessmentLayoutManager manager, String text,
			ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		MultilineString label = new MultilineString("");
		try {
			ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();

			TextDisplayComponent tdc = new TextDisplayComponent(label, 0, 0,
					layoutPanel);
			PropertyEditorPanel aPEPanel = new PropertyEditorPanel(tdc);
			PropertyDialog pd = new PropertyDialog(this.manager, "Add Text",
					aPEPanel);
			pd.setLocationRelativeTo(layoutPanel);
			int rc = pd.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(tdc);
				this.manager.getStatusBar().setText(
					"Click anywhere on the layout to insert (multiline) text");
			}
			pd.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}

}