package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.PropertyDialog;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.TextAreaDisplayComponent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddTextAreaAdapter.java,v 1.1.2.1 2007/06/11 21:25:53 bozyurt
 *          Exp $
 */
public class AddTextAreaAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 5836115006172605957L;

	public AddTextAreaAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();
		TextAreaDisplayComponent ta = new TextAreaDisplayComponent(0, 0,
				layoutPanel);
		try {
			PropertyEditorPanel aPEPanel = new PropertyEditorPanel(ta);
			PropertyDialog pd = new PropertyDialog(this.manager,
					"Add Text Area Field", aPEPanel);
			int rc = pd.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(ta);
				this.manager.getStatusBar().setText(
					"Click anywhere on the layout to insert a text area field");
			}
			pd.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}