package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.propedit.PropertyEditorPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.PropertyDialog;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.TextFieldDisplayComponent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AddTextFieldAdapter.java,v 1.1.2.1 2007/06/11 21:25:53 bozyurt
 *          Exp $
 */
public class AddTextFieldAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 6356118109347209932L;

	public AddTextFieldAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();
		TextFieldDisplayComponent tf = new TextFieldDisplayComponent(0, 0,
				layoutPanel);
		try {
			PropertyEditorPanel aPEPanel = new PropertyEditorPanel(tf);
			PropertyDialog pd = new PropertyDialog(this.manager,
					"Add Text Field", aPEPanel);
			int rc = pd.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				layoutPanel.setSelectedComponent(tf);
				this.manager.getStatusBar().setText(
						"Click anywhere on the layout to insert a text field");
			}
			pd.dispose();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}