package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import caslayout.ui.AssessmentDifferenceDialog;
import caslayout.ui.AssessmentListSelectDialog;
import caslayout.ui.CALMConfig;
import caslayout.ui.CALMHelper;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.Document;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.model.AsDiffInfo;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssessmentMaintenanceHelper;
import caslayout.ui.model.AssociationHelper;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: BatchSaveAssessmentAdapter.java,v 1.1.2.1 2007/06/11 21:25:53
 *          bozyurt Exp $
 */
public class BatchSaveAssessmentAdapter extends AbstractAction {
	private static final long serialVersionUID = 1L;
	private final ClinicalAssessmentLayoutManager manager;

	public BatchSaveAssessmentAdapter(ClinicalAssessmentLayoutManager manager,
			String name, ImageIcon icon, String desc, Integer mnemonic) {
		super(name, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent e) {
		File defaultDir = null;
		if (manager.getSavedState().getLastDirectory() != null) {
			File f = new File(manager.getSavedState().getLastDirectory());
			if (f.isDirectory()) {
				defaultDir = f;
			}
		}
		AssessmentListSelectDialog dlg = new AssessmentListSelectDialog(manager,"Batch Save Assessments to DB", defaultDir);
		int rc = dlg.showDialog();
		if ( rc == BaseDialog.OK_PRESSED) {
			List<String> asPathList = dlg.getSelectedAssessments();
			CALMConfig config = manager.getConfig();
			ScoreLayoutPanel slPanel = new ScoreLayoutPanel("Score Layout", true, manager, config);
			for (Object element : asPathList) {
				String asPath = (String) element;
				try {
					if (asPath.endsWith(".calm")) {
						CALMHelper.buildDocument(asPath,	slPanel, config);
					} else {
						Document.loadDocument(asPath, manager);
					}

					AssociationHelper assocHelper = AssociationHelper.getInstance();
					AssessmentAssociation aa = assocHelper.getAsAssoc();
					AssessmentInfo asi = null;
					if (aa.getLeft() != null) {
						asi = aa.getLeft();
					}
					assert(asi != null);
					saveAsType2DB(asi);

				} catch(Exception x) {
					x.printStackTrace();
					CALMHelper.showError(manager, x.getMessage());
				}
			}
		}
		dlg.dispose();
	}

	protected void saveAsType2DB(AssessmentInfo asi) throws Exception {
		boolean deleteExistingData = false;
        int rc;
		AssessmentInfo dbAsi = AssessmentMaintenanceHelper
				.loadAssessment(manager.getConfig(), asi.getName());

		if (dbAsi != null) {
			java.util.List<AsDiffInfo> diffList = AssessmentMaintenanceHelper
					.findAssessmentDifference(dbAsi, asi);
			AssessmentDifferenceDialog adDlg = new AssessmentDifferenceDialog(
					null, "Assessment Difference", diffList, asi
							.getName());
			adDlg.setLocationRelativeTo(this.manager);
			adDlg.showDialog();

			adDlg.dispose();
			if (diffList.isEmpty()) {
				int rc2 = JOptionPane.showConfirmDialog(manager,
								"No changes detected! Do you want to remove and recreate the assessment in db anyway?",
								"Forced Assessment Recreation",
								JOptionPane.YES_NO_OPTION);
				if (rc2 == JOptionPane.NO_OPTION) {
					// no change is necessary!
					return;
				}
			}
			// check if only assessment items differ
			boolean asItemChangesOnly = AssessmentMaintenanceHelper
					.hasOnlyAssessmentItemChanges(diffList);

			if (asItemChangesOnly && !diffList.isEmpty()) {
				rc = JOptionPane.showConfirmDialog(manager,
						"Do you want apply assessment items changes?",
						"Assessment Item Synchronization",
						JOptionPane.YES_NO_OPTION);
				if (rc == JOptionPane.YES_OPTION) {
					AssessmentMaintenanceHelper.updateAssessmentItems(
							manager.getConfig(), asi);
				}
			} else {
				// assessment scores or score codes have been
				// changed
				rc = JOptionPane
						.showConfirmDialog(manager,
								"Do you want to delete any existing assessment data associated also ?",
								"Existing Assessment Data Deletion",
								JOptionPane.YES_NO_OPTION);
				deleteExistingData = rc == JOptionPane.YES_OPTION;
				AssessmentMaintenanceHelper.saveAssessment(manager
						.getConfig(), asi, deleteExistingData);

				JOptionPane.showMessageDialog(manager,
						"Assessment '" + asi.getName() + "'is saved to the database!", "Success",
						JOptionPane.PLAIN_MESSAGE);
				manager.getStatusBar().setText(
						"Saved the assessment info to the database.");

			}
		} else {
			// new assessment (not in db)
			AssessmentMaintenanceHelper.saveAssessment(
					manager.getConfig(), asi, false);

			JOptionPane.showMessageDialog(manager,
					"Assessment '" + asi.getName() + "'is saved to the database!", "Success",
					JOptionPane.PLAIN_MESSAGE);
			manager.getStatusBar().setText(
					"Saved the assessment info to the database.");
		}
	}


}
