package caslayout.ui.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

import caslayout.codegen.HTMLGenerator;
import caslayout.ui.CALMHelper;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.Document;
import caslayout.ui.Page;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.SuffixFileFilter;
import caslayout.util.GUIUtils;
import caslayout.util.GenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: GenerateHTMLAdapter.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class GenerateHTMLAdapter extends AbstractAction {
   private final ClinicalAssessmentLayoutManager manager;
   private static final long serialVersionUID = 4585461330323997817L;

   public GenerateHTMLAdapter(ClinicalAssessmentLayoutManager manager,
         String text, ImageIcon icon, String desc, Integer mnemonic) {
      super(text, icon);
      this.manager = manager;
      putValue(SHORT_DESCRIPTION, desc);
      putValue(MNEMONIC_KEY, mnemonic);
   }

   public void actionPerformed(ActionEvent ae) {
      ScoreLayoutPanel layoutPanel = this.manager.getSlPanel();

      JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
      fc.setFileFilter(new SuffixFileFilter(".html", "HTML Files"));
      int rc = fc.showSaveDialog(layoutPanel);

      if (rc == JFileChooser.APPROVE_OPTION) {
         Document doc = ClinicalAssessmentLayoutManager.getCurDoc();
         String htmlFilename = fc.getSelectedFile().getAbsolutePath();
         String baseName = GenUtils.getBasename(htmlFilename);
         int pageNo = 1;
         BufferedWriter bout = null;
         for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
            Page page = iter.next();
            bout = null;
            try {
               String filename = fc.getSelectedFile().getParent()
                     + File.separator + baseName + "_page_" + pageNo + ".html";
               HTMLGenerator htmlGen = new HTMLGenerator(page.getViewPanel());

               bout = new BufferedWriter(new FileWriter(filename));

               htmlGen.generate(bout);
               GUIUtils.showStatusMessage(layoutPanel,
                     "Saved the layout as HTML to " + filename);
            } catch (IOException iox) {
               CALMHelper.showError(layoutPanel, iox.getMessage(),
                     "Error while saving generated HTML");
               ClinicalAssessmentLayoutManager.getLog().error(
                     "HTML Generation Error", iox);
            } finally {
               GenUtils.close(bout);
            }

            ++pageNo;
         } // for
      }
   }
}