package caslayout.ui.actions;

import guilib.common.BaseDialog;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import org.jdom.Element;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.ImportConfig;
import caslayout.importing.excel.ExcelImportInfo;
import caslayout.importing.ui.CommonOptionsPanel;
import caslayout.importing.ui.QuestionsPerPagePanel;
import caslayout.ui.CALMHelper;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.wizard.IWizardUsable;
import caslayout.ui.wizard.WizardDialog;
import caslayout.util.XMLUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ImportAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class ImportAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 1L;

	public ImportAdapter(ClinicalAssessmentLayoutManager manager, String text,
			ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent e) {
		IWizardUsable[] screens = new IWizardUsable[2];

		CALMHelper.SavedState savedState = manager.getSavedState();
		String lastDir = null;
		if (savedState != null) {
			lastDir = savedState.getLastDirectory();
		}

		CommonOptionsPanel cop = null;
		if (lastDir != null) {
			String scaGenDir = manager.getConfig().getScaGenDir();
			
			cop = new CommonOptionsPanel(lastDir, scaGenDir);
		} else {
			cop = new CommonOptionsPanel();
		}
		QuestionsPerPagePanel qp3 = new QuestionsPerPagePanel();
		cop.addPropertyChangeListener(qp3);

		screens[0] = cop;
		screens[1] = qp3;

		WizardDialog dlg = new WizardDialog(manager,
				"Import Clinical Assessment", screens);
		cop.registerWizardListener(dlg);
		qp3.registerWizardListener(dlg);

		int rc = dlg.showDialog();
		if (rc == BaseDialog.OK_PRESSED) {
			ExcelImportInfo ii = (ExcelImportInfo) dlg.getPayload();
			Assessment as = ii.getExcelImporter().getAssessment();
			ImportConfig ic = ii.getImportConfig();
			
			Element calmElem = as.toCALM(ic);
			String calmFile = ic.getScaFilename();
			try {
				XMLUtils.saveXML(calmElem, calmFile);
				manager.getStatusBar().setText("saved imported assessment to file:" + calmFile);			
				manager.handleImportCALMCADoc(calmFile);
				
			} catch (Exception ex) {
				ex.printStackTrace();
				CALMHelper.showError(manager, ex.getMessage(), "Import Error");			
			}
		}
		dlg.dispose();
	}

}
