package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import caslayout.ui.CAPanel;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.Document;
import caslayout.ui.Page;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssessmentMaintenanceHelper;
import caslayout.ui.model.AssociationHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: NewDocumentAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class NewDocumentAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -1945074846320718511L;

	public NewDocumentAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {

		Document currentDoc = ClinicalAssessmentLayoutManager.getCurDoc();
		if (currentDoc != null) {
			// give user chance to save the previous document
			int rc = JOptionPane.showConfirmDialog(
					this.manager,
					"Do you want to save the current document?");
			if (rc == JOptionPane.YES_OPTION) {
				manager.onSaveAs();
			}

		}
		// create an empty single page document
		Document newDoc = new Document("empty", "");
		ClinicalAssessmentLayoutManager.setCurDoc(newDoc);
		newDoc.addPage(new Page(1));
		CAPanel aPanel = this.manager.getSlPanel().createDefaultPanel(false);
		this.manager.getSlPanel().setCAContainerAt(aPanel, 0);

		newDoc.getFirstPage().setViewPanel(aPanel);
		// show assocs and questions if set
		manager.getSlPanel().showAssociations( manager.isShowAssocs());
		manager.getSlPanel().showQuestions( manager.isShowQuestions());
		manager.getSlPanel().repaint();
		manager. getPageEditComp()
				.changePageNumbers(newDoc.getNumPages());

		manager.setCurLayoutFile(null);

		try {
			AssociationHelper.getInstance().reset();
			AssessmentInfo asi = AssessmentMaintenanceHelper
					.loadAssessment(manager.getConfig());

			manager.updateAssessmentTreePane(asi);
		} catch (Exception x) {
			x.printStackTrace();
		}
		this.manager.getStatusBar().setText(
				"Created a new document.");
	}
}