package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import caslayout.ui.AssessmentDifferenceDialog;
import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.model.AsDiffInfo;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssessmentMaintenanceHelper;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SaveAssessmentAdapter.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class SaveAssessmentAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 2758769485081665000L;

	public SaveAssessmentAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		AssessmentInfo asi = manager.getAssessmentInfo();

		try {
			int rc = JOptionPane.showConfirmDialog(manager, "The assessment "
					+ asi.getName()
					+ " will be saved (with its scores/score codes\n"
					+ " and assessment items) to the database. "
					+ "Do you want to continue?", "Saving Assessment",
					JOptionPane.YES_NO_OPTION);
			if (rc == JOptionPane.YES_OPTION) {
				ClinicalAssessmentLayoutManager calm = manager;
				boolean deleteExistingData = false;

				AssessmentInfo dbAsi = AssessmentMaintenanceHelper
						.loadAssessment(calm.getConfig(), asi.getName());

				if (dbAsi != null) {
					java.util.List<AsDiffInfo> diffList = AssessmentMaintenanceHelper
							.findAssessmentDifference(dbAsi, asi);
					AssessmentDifferenceDialog adDlg = new AssessmentDifferenceDialog(
							null, "Assessment Difference", diffList, asi
									.getName());
					adDlg.setLocationRelativeTo(this.manager);
					adDlg.showDialog();
					adDlg.dispose();

					if (diffList.isEmpty()) {
						int rc2 = JOptionPane.showConfirmDialog(manager,
										"No changes detected! Do you want to remove and recreate the assessment in db anyway?",
										"Forced Assessment Recreation",
										JOptionPane.YES_NO_OPTION);
						if (rc2 == JOptionPane.NO_OPTION) {
							// no change is necessary!
							return;
						}
					}
					// check if only assessment items differ
					boolean asItemChangesOnly = AssessmentMaintenanceHelper
							.hasOnlyAssessmentItemChanges(diffList);

					if (asItemChangesOnly && !diffList.isEmpty()) {
						rc = JOptionPane.showConfirmDialog(this.manager,
								"Do you want apply assessment items changes?",
								"Assessment Item Synchronization",
								JOptionPane.YES_NO_OPTION);
						if (rc == JOptionPane.YES_OPTION) {
							AssessmentMaintenanceHelper.updateAssessmentItems(
									calm.getConfig(), asi);
						}
					} else {
						// assessment scores or score codes have been
						// changed
						rc = JOptionPane
								.showConfirmDialog(
										manager,
										"Do you want to delete any existing assessment data associated also ?",
										"Existing Assessment Data Deletion",
										JOptionPane.YES_NO_OPTION);
						deleteExistingData = rc == JOptionPane.YES_OPTION;
						AssessmentMaintenanceHelper.saveAssessment(calm
								.getConfig(), asi, deleteExistingData);

						JOptionPane.showMessageDialog(calm,
								"Assessment is saved to the database!",
								"Success", JOptionPane.PLAIN_MESSAGE);
						calm.getStatusBar().setText(
								"Saved the assessment info to the database.");

					}
				} else {
					// new assessment (not in db)
					AssessmentMaintenanceHelper.saveAssessment(
							calm.getConfig(), asi, false);

					JOptionPane.showMessageDialog(calm,
							"Assessment is saved to the database!", "Success",
							JOptionPane.PLAIN_MESSAGE);
					calm.getStatusBar().setText(
							"Saved the assessment info to the database.");
				}
			}
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}