package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.CurrentState;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SelectionToolAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class SelectionToolAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -3863583478652273325L;

	public SelectionToolAdapter(ClinicalAssessmentLayoutManager manager, String text, ImageIcon icon, String desc,
			Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		ScoreLayoutPanel layoutPanel = manager.getSlPanel();
		layoutPanel.getCurrentState().setState(CurrentState.SELECTION);
		manager.getStatusBar().setText(
				"Press right mouse button and drag for selection.");
	}
}