package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;

import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ShowAssociationsAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class ShowAssociationsAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = 3655235157120305567L;

	public ShowAssociationsAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		JCheckBoxMenuItem cbMenu = (JCheckBoxMenuItem) ae.getSource();
		ScoreLayoutPanel layoutPanel = manager.getSlPanel();
		this.manager.setShowAssocs(cbMenu.isSelected());

		layoutPanel.showAssociations(cbMenu.isSelected());
		layoutPanel.repaint();
	}
}