package caslayout.ui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;

import caslayout.ui.ClinicalAssessmentLayoutManager;
import caslayout.ui.ScoreLayoutPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ShowQuestionsAdapter.java,v 1.2 2007/10/08 18:00:41 bozyurt Exp $
 */
public class ShowQuestionsAdapter extends AbstractAction {
	private final ClinicalAssessmentLayoutManager manager;
	private static final long serialVersionUID = -5833998443912412625L;

	public ShowQuestionsAdapter(ClinicalAssessmentLayoutManager manager,
			String text, ImageIcon icon, String desc, Integer mnemonic) {
		super(text, icon);
		this.manager = manager;
		putValue(SHORT_DESCRIPTION, desc);
		putValue(MNEMONIC_KEY, mnemonic);
	}

	public void actionPerformed(ActionEvent ae) {
		JCheckBoxMenuItem cbMenu = (JCheckBoxMenuItem) ae.getSource();
		ScoreLayoutPanel layoutPanel = manager.getSlPanel();
		manager.setShowQuestions(cbMenu.isSelected());

		layoutPanel.showQuestions(cbMenu.isSelected());
		layoutPanel.repaint();
	}
}